package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.GeneralPageTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 设计器：组件选择另外一个数据源处理类
 *
 * @author yanfeng
 * @date 2023/12/7
 */
@Component("uiBotModelDesignerMultipleDataSources")
public class UiBotModelDesignerMultipleDataSources {

    public static final String VSS_STOCK_ALERT = "vss_stock_alert";
    public static final String VSS_ORDER_ALERT = "vss_order_alert";


    private static GeneralPageTemplate generalPageTemplate;

    private static DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    public UiBotModelDesignerMultipleDataSources(GeneralPageTemplate generalPageTemplate, DigiwinEspProxyService digiwinEspProxyService) {
        UiBotModelDesignerMultipleDataSources.generalPageTemplate = generalPageTemplate;
        UiBotModelDesignerMultipleDataSources.digiwinEspProxyService = digiwinEspProxyService;
    }

    /**
     * 多数据源处理，修改dataSourceName
     *
     * @param tmActivity
     * @author yanfeng
     */
    public static void handleMultipleDataSources(PcUiBotTmActivity tmActivity) {
        //当前页面pageId
        if (!StringUtils.isEmpty(AppRequestContext.getContextEntity().getPageId())) {
            String pageId = AppRequestContext.getContextEntity().getPageId();
            if (ObjectUtils.isEmpty(tmActivity) || ObjectUtils.isEmpty(tmActivity.getPages())) {
                return;
            }
            List<PcUiBotTmDataState> dataStates = tmActivity.getPages().getDataStates();
            for (PcUiBotTmDataState dataState : dataStates) {
                if (!CollectionUtils.isEmpty(dataState.getPageLayout())) {
                    for (UiBotPageLayout uiBotPageLayout : dataState.getPageLayout()) {
                        if (!CollectionUtils.isEmpty(uiBotPageLayout.getBody())) {
                            if (pageId.equalsIgnoreCase(uiBotPageLayout.getPageId())) {
                                for (BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper : uiBotPageLayout.getBody()) {
                                    if (!ObjectUtils.isEmpty(componentWrapper)) {
                                        String componentType = componentWrapper.getComponentType();
                                        if (("DW_" + TaskProgressList.COMPONENT_TYPE).equals(componentType)) {
                                            TaskProgressList taskProgressList = JsonUtil.objectToJavaObject(componentWrapper.getData(), new TypeReference<TaskProgressList>() {
                                            });
                                            if (ObjectUtils.isEmpty(taskProgressList)) {
                                                return;
                                            }
                                            if (CollectionUtils.isEmpty(taskProgressList.getTaskProgressList())) {
                                                return;
                                            }
                                            for (TaskProgress taskProgress : taskProgressList.getTaskProgressList()) {
                                                if (CollectionUtils.isEmpty(taskProgress.getPersonList())) {
                                                    return;
                                                }
                                                tmActivity.getPages().setDataSourceName(taskProgress.getDataSource().getActionName());
                                                dataState.getDataFilter().setApiCondition(new ArrayList<>());
                                                AppRequestContext.getContextEntity().setDataSourceName(taskProgress.getDataSource().getActionName());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

    }

    /**
     * 多数据源查询
     * 根据设计器数据源配置->条件配置(重要：配置必须在第一个)：
     * 参数名称: 等于 PcUiBotActionParameterMapping对象的name
     * 参数类型：固定：CONSTANT(常量)
     * 参数值(逗号隔开)：等于 PcUiBotActionParameterMapping对象的value
     *
     * @param dataSourceSet 数据源集合
     * @param apiRequest    apiRequest
     */
    public static void handleDataSourceParas(PcUiBotDataSourceSetDTO dataSourceSet, ApiRequest apiRequest) {
        if (ObjectUtils.isEmpty(apiRequest.getRawData().get("data"))) {
            return;
        }
        dataSourceSet.getDataSourceList().forEach(dataSource -> {
            if (ObjectUtils.isNotEmpty(dataSource.getAction())
                    && !CollectionUtils.isEmpty(dataSource.getAction().getActionParams())) {
                PcUiBotActionParameterMapping mapping = dataSource.getAction().getActionParams().get(0);
                if (mapping.getValue().contains(",")) {
                    List<String> stringList = Arrays.stream(mapping.getValue().split(",")).map(String::valueOf).collect(Collectors.toList());
                    HashMap<String, Object> map = new HashMap<>(1);
                    List<Map<String, Object>> list = new ArrayList<>(1);
                    Map<String, Object> dataMap = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("data"), new TypeReference<Map<String, Object>>() {
                    });
                    Map<String, Object> info = stringList.stream().collect(Collectors.toMap(s -> s, dataMap::get, (a, b) -> b, () -> new HashMap<>(6)));
                    list.add(info);
                    map.put(mapping.getName(), list);
                    dataSource.getAction().getParas().putAll(map);
                }
            }
        });
    }

    /**
     * 多数据源查询元数据
     *
     * @param absEntity
     * @param pageDefines
     */
    public static void queryMetadataMultipleSources(AbstractEntity absEntity, List<PcUiBotTaskPageDefine> pageDefines) {
        if (StringUtil.isNotEmpty(AppRequestContext.getContextEntity().getDataSourceName())) {
            PcUiBotDataSourceDTO dataSource = pageDefines.get(0).getDataSourceSet().getDataSourceList().get(0);
            if (ObjectUtils.isNotEmpty(dataSource.getAction())
                    && !CollectionUtils.isEmpty(dataSource.getAction().getActionParams())) {
                PcUiBotActionParameterMapping mapping = dataSource.getAction().getActionParams().get(0);
                if (mapping.getValue().contains(",")) {
                    handleMultipleDataSources(absEntity, pageDefines.get(0));
                }
            }
        }
    }

    /**
     * 多数据源替换data
     *
     * @param absEntity
     * @param pageDefines
     */
    public static void handleMultipleDataSources(AbstractEntity absEntity, PcUiBotTaskPageDefine pageDefines) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        QueryResultSet queryResultSet = generalPageTemplate.BuildDataSource(executeContext, pageDefines, uiBotModel, apiRequest);
        HashMap<Object, Object> rawMap = new HashMap<>();
        rawMap.put(queryResultSet.getDataSourceNameFromApiResp(), queryResultSet.getQueryResultData());
        apiRequest.getRawData().put("rawDataType", "array");
        //当前节点数据
        apiRequest.getRawData().put("data", rawMap);
        //元数据
        apiRequest.getRawData().put("rawMap", rawMap);
    }

    /**
     * 处理vss 供应天眼 任务卡
     * todo 2023.12.8 yanfeng 供应天眼，先定制写在这里，后期会通过js移走
     *
     * @param apiRequest
     * @param executeContext
     * @author yanfeng
     */
    public static void handleVssTask(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        if (VSS_STOCK_ALERT.equalsIgnoreCase(executeContext.getTmActivityId())
                || VSS_ORDER_ALERT.equalsIgnoreCase(executeContext.getTmActivityId())) {
            List<Map<String, Object>> params = null;
            //库存预警
            if (VSS_STOCK_ALERT.equalsIgnoreCase(executeContext.getTmActivityId())) {
                params = JsonUtil.objectToJavaObject(executeContext.getBpmData().get("stockAlertParams"), new TypeReference<List<Map<String, Object>>>() {
                });
            }
            //订单预警
            if (VSS_ORDER_ALERT.equalsIgnoreCase(executeContext.getTmActivityId())) {
                params = JsonUtil.objectToJavaObject(executeContext.getBpmData().get("orderAlertParams"), new TypeReference<List<Map<String, Object>>>() {
                });
            }
            digiwinEspProxyService.updateTaskWarnInvImsc(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        }
    }

}
