package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataReq;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataResult;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>功能描述：组件/页面选择另外一个数据源处理类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotMultipleDataSourceService.java
 * @Author: wangjwc
 * @Date: created at 2024/9/9 15:27
 */
@Slf4j
@Component
public class UiBotMultipleDataSourceService {

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private QueryActionCreateService queryActionCreateService;

    /**
     * 构建页面/弹窗多数据源数据
     * null: 不用处理
     */
    public Map<String, Object> buildPageMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, UiBotPageLayout pageLayout, Map<String, Object> rawParam) {
        try {
            if (pageLayout == null) {
                return null;
            }
            return this.buildMultipleDataSourceData(cmptContext, executeContext, pageLayout.getDataSource(), rawParam);
        } catch (Exception e) {
            log.error("build page multiple datasource data error", e);
        }
        return null;
    }

    /**
     * 构建组件多数据源数据
     * null: 不用处理
     */
    public Map<String, Object> buildCmptMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        try {
            return this.buildMultipleDataSourceData(cmptContext, executeContext, dataSource, rawParam);
        } catch (Exception e) {
            log.error("build cmpt multiple datasource data error", e);
        }
        return null;
    }

    private Map<String, Object> buildMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        // 判断是否需要替换数据源
        if (!this.judgeIsMultipleDataSource(cmptContext, executeContext, dataSource)) {
            return null;
        }
        // 构建参数
        Map<String, Object> parameter = this.buildRequestParamter(executeContext, dataSource, rawParam);
        // 查询数据
        return this.dataQueryByActionId(executeContext, dataSource.getActionId(), parameter);
    }

    private Boolean judgeIsMultipleDataSource(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource) {
        if (BooleanUtils.isTrue(cmptContext.getSkipMultiDataSource())) {
            // 跳过多数据源
            return false;
        }
        if (Objects.equals(true, executeContext.getOpenDetailPage())) {
            // 开兄弟详情不用替换数据源
            return false;
        }
        if (dataSource == null || StringUtils.isEmpty(dataSource.getActionId())) {
            return false;
        }
        if (StringUtils.isEmpty(executeContext.getMainDataSourceName()) || StringUtils.isEmpty(dataSource.getActionName())) {
            // 主数据源不存在，不用处理
            return false;
        }
        if (Objects.equals(dataSource.getActionName(), executeContext.getMainDataSourceName())) {
            // 主数据源，不用处理
            return false;
        }
        return true;
    }

    private Map<String, Object> dataQueryByActionId(PcUiBotExecuteContext executeContext, String actionId, Map<String, Object> parameter) {
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create(actionId,
                parameter,
                JsonUtil.objectToJavaObject(executeContext, Map.class),
                JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class),
                null, null, null
        );
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = digiwinAtdmProxyService.dataQueryByActionId(
                AppRequestContext.getContextEntity().getLocale(),
                AppRequestContext.getContextEntity().getIamUserToken(),
                JsonUtil.javaObjectToJsonString(request),
                AppRequestContext.getContextEntity().getTenantId()
        );
        if (athenaApiResponse == null) {
            return null;
        }
        return athenaApiResponse.getResponse();
    }

    private Map<String, Object> buildRequestParamter(PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        List<PcUiBotActionParameterMapping> actionParams = dataSource.getActionParams();
        if (CollectionUtils.isEmpty(actionParams)) {
            return new HashMap<>();
        }
        Map<String, Object> bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap<>());
        Map<String, Object> convertParas = this.setActionParameter(dataSource.getParas(), actionParams, bpmData, executeContext);
        dataSource.getParas().putAll(!CollectionUtils.isEmpty(convertParas) ? convertParas : new HashMap<>());
        //如果需要前端传如参数,则把需要传的参数放入到ActionParams
        dataSource.setActionParams(new ArrayList<>());
        for (PcUiBotActionParameterMapping actionParam : actionParams) {
            if ("ACTIVE_ROW".equals(actionParam.getType())
                    || "TM_VARIABLE".equals(actionParam.getType())) {
                dataSource.getActionParams().add(actionParam);
            }
        }
        // 处理传递过来的参数
        this.processParameter(dataSource, rawParam, executeContext);

        return dataSource.getParas();
    }

    /**
     * 处理 查询ACTION 参数
     */
    private Map<String, Object> setActionParameter(Map<String, Object> paraMap, List<PcUiBotActionParameterMapping> actionParameterMappings, Map<String, Object> bpmData, PcUiBotExecuteContext executeContext) {

        if (bpmData == null || CollectionUtils.isEmpty(actionParameterMappings)) {
            return paraMap;
        }

        //优先处理流程参数，因为其他参数是附加到流程参数内部的
        Map<String, Object> map = Maps.newHashMapWithExpectedSize(2);
        // 存入含有xx.aa映射的关系
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if ("PROCESS_VARIABLE".equals(tmActionRequestParameter.getType())) {
                if (bpmData.containsKey(tmActionRequestParameter.getValue())) {
                    //使用原始的数据，需要API自行控制数据的状态
                    paraMap.put(tmActionRequestParameter.getName(), bpmData.get(tmActionRequestParameter.getValue()));
                } else {
                    // 兼容xx.xx的value
                    String value = tmActionRequestParameter.getValue();
                    if (StringUtils.isNotBlank(value)) {
                        // 根据.分割
                        String[] sourcesNames = value.split("\\.");
                        if (sourcesNames.length == 2) {
                            // 含.的才走
                            // 取值
                            Object o = bpmData.get(sourcesNames[0]);
                            // 如果是map类型
                            if (o instanceof Map) {
                                // 对应当前value值
                                Object o1 = ((Map) o).get(sourcesNames[1]);
                                // 需要转换后的属性
                                String name = tmActionRequestParameter.getName();
                                String[] targetNames = name.split("\\.");
                                // 如果只有1个,直接放入当前值
                                if (targetNames.length == 1) {
                                    map.put(targetNames[0], o1);
                                } else if (targetNames.length == 2) {
                                    // 如果是2个代表结果值为map
                                    Map<String, Object> targetMap = (Map<String, Object>) map.computeIfAbsent(targetNames[0], e -> Maps.newHashMapWithExpectedSize(2));
                                    targetMap.put(targetNames[1], o1);
                                }
                            } else if (o instanceof List) {
                                // 如果为数组
                                List list = (List) o;
                                int size = list.size();
                                if (size > 0) {
                                    String name = tmActionRequestParameter.getName();
                                    String[] targetNames = name.split("\\.");
                                    // 目标的长度为1，代表值为集合为基本数据类型
                                    if (targetNames.length == 1) {
                                        for (Object o1 : list) {
                                            if (o1 instanceof Map) {
                                                map.put(targetNames[0], ((Map) o1).get(sourcesNames[1]));
                                            }
                                        }
                                    } else if (targetNames.length == 2) {
                                        // 目标的长度为2，代表值为集合中的类型为map
                                        // 进行初始化
                                        for (int i = 0; i < size; i++) {
                                            List<Map<String, Object>> targetList = (List<Map<String, Object>>) map.computeIfAbsent(targetNames[0], e -> Lists.newArrayListWithCapacity(size));
                                            Map<String, Object> row;
                                            if (targetList.size() < (i + 1)) {
                                                row = new HashMap<>();
                                                targetList.add(row);
                                            } else {
                                                row = targetList.get(i);
                                            }
                                            Object o1 = list.get(i);
                                            Object targetValue = null;
                                            if (o1 instanceof Map) {
                                                targetValue = ((Map) o1).get(sourcesNames[1]);
                                            }
                                            row.put(targetNames[1], targetValue);
                                        }
                                    }

                                }
                            }
                        }
                    }
                }
            }
        }

        if (!map.isEmpty()) {
            paraMap.putAll(map);
        }

        //优先处理指定参数，因为其他参数是附加到参数内部的
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            //结构 xxx.aa xxx:数组节点 aa: 对象KEY
            if ("RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())) {
                //流程参数
                String[] pathName = StringUtils.split(tmActionRequestParameter.getName(), ".");
                String paramKey = pathName[0];
                String paramNodeKey = pathName[1];
                String value = tmActionRequestParameter.getValue();
                List<Map<String, Object>> dataList = new ArrayList<>();
                if (null != paraMap.get(paramKey)) {
                    dataList = (List<Map<String, Object>>) paraMap.get(paramKey);
                }
                Map<String, Object> dataP = new HashMap<>();
                if (!CollectionUtils.isEmpty(dataList)) {
                    dataP = dataList.get(0);
                } else {
                    dataList.add(dataP);
                }
                for (Object o : bpmData.keySet()) {
                    String dataKey = StringUtil.valueOf(o);
                    if (dataKey.equals(value)) {
                        dataP.put(paramNodeKey, bpmData.get(dataKey));
                    }
                }
                if (!CollectionUtils.isEmpty(dataList)) {
                    paraMap.put(paramKey, dataList);
                }
            }
        }
        // 最后再处理其他单个参数
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if ("CONSTANT".equals(tmActionRequestParameter.getType())
                    || "ACTIVE_ROW_CONSTANT".equals(tmActionRequestParameter.getType())
                    || "SYSTEM".equals(tmActionRequestParameter.getType())) {
                // 常规参数处理
                setSinglePara(paraMap, tmActionRequestParameter, JsonUtil.objectToJavaObject(bpmData, JSONObject.class), executeContext);
            }
        }
        return paraMap;
    }

    private void setSinglePara(Map<String, Object> paraMap, PcUiBotActionParameterMapping tmActionRequestParameter, JSONObject bpmData, PcUiBotExecuteContext executeContext) {
        //服务端 过滤
        String conName = tmActionRequestParameter.getName();
        if (conName.contains(".")) {
            //指定过滤条件加在哪个参数中
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList<>());
                    } else {
                        if (!convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            } else if (p instanceof Map) {
                Map pJson = (Map) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList<>());
                    } else {
                        if (!convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray) p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (oJson instanceof JSONObject) {
                        JSONObject pJson = (JSONObject) oJson;
                        if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                        } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                        } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList<>());
                        } else {
                            if (!convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                                pJson.put(conNames[1], tmActionRequestParameter.getValue());
                            }
                        }
                    }
                }
            } else if (p instanceof List) {
                List pJsonArray = (List) p;
                for (Object o : pJsonArray) {
                    if (o instanceof Map) {
                        Map pJson = (Map) o;
                        if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList<>());
                        } else {
                            if (!convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                                pJson.put(conNames[1], tmActionRequestParameter.getValue());
                            }
                        }
                    }
                }
            } else {
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    paraMap.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    paraMap.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if (!convertAtmcSystemVariable(bpmData, paraMap, conNames[1], tmActionRequestParameter.getValue())) {
                        paraMap.put(conNames[1], null);
                    }
                }
            }
        } else {
            if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), executeContext.getAuthoredUser().getUserId());
            } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
            } else {
                if ("[]".equals(tmActionRequestParameter.getValue())) {
                    //常量为[]进行特殊处理，表示空组数
                    paraMap.put(tmActionRequestParameter.getName(), new ArrayList<>());
                } else {
                    if (!convertAtmcSystemVariable(bpmData, paraMap, tmActionRequestParameter.getName(), tmActionRequestParameter.getValue())) {
                        paraMap.put(tmActionRequestParameter.getName(), tmActionRequestParameter.getValue());
                    }
                }
            }
        }
    }

    private boolean convertAtmcSystemVariable(JSONObject bpmData, Map pJson, String addKeyName, String tmValue) {
        if (!StringUtils.isEmpty(tmValue) && bpmData != null && bpmData.containsKey("ATMC_GLOBAL_VARIABLE") && bpmData.get("ATMC_GLOBAL_VARIABLE") != null) {
            if (StringUtils.startsWithIgnoreCase(tmValue, "{@") && StringUtils.endsWithIgnoreCase(tmValue, "}")) {
                tmValue = tmValue.substring(2, tmValue.length() - 1);
                JSONObject atmcData = bpmData.getJSONObject("ATMC_GLOBAL_VARIABLE");
                if (atmcData.containsKey(tmValue)) {
                    pJson.put(addKeyName, atmcData.get(tmValue));
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * 处理传递过来的参数
     *
     * @param parameter 元数据
     */
    private void processParameter(DataSource dataSource, Map<String, Object> parameter, PcUiBotExecuteContext executeContext) {
        if (null == dataSource) {
            return;
        }
        //获取元数据
        PcUiBotApiMetadata metadata = queryActionCreateService.getMetadata(executeContext, dataSource.getActionId());
        List<PcUiBotMetadataField> requestFields = metadata == null ? new ArrayList<>() : metadata.getRequestFields();

        //如果前端有传参数，则做替换
        if (parameter != null) {
            if (CollectionUtils.isEmpty(dataSource.getActionParams())) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    dataSource.getParas().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else {
                Map<String, Object> realParas = dataSource.getParas();
                for (PcUiBotActionParameterMapping actionParam : dataSource.getActionParams()) {
                    if ("TM_VARIABLE".equals(actionParam.getType())) {
                        // action.getValue为非空，则尝试获取KM配置；否则action.value值保持原样
                        if (StringUtils.isNotBlank(actionParam.getValue())) {
                            Map<String, Object> variableMap = digiwinKnowledgeMapsProxyService
                                    .getMechanismParamValue(executeContext.getAuthoredUser().getToken(),
                                            executeContext.getTenantId(), executeContext.getLocale(), actionParam.getValue());
                            Object value = variableMap.get(actionParam.getValue());

                            actionParam.setValue(null != value ? String.valueOf(value) : null);
                        }
                        actionParam.setType("CONSTANT");
                    }

                    if ("ACTIVE_ROW".equals(actionParam.getType())) {
                        Object paramValue = parameter.get(actionParam.getValue());
                        /*if(paramValue ==  null){
                            continue;
                        }*/
                        if (actionParam.getTypeConverter() != null) {
                            try {
                                if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert(paramValue.toString(), Boolean.TYPE);
                                } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert(paramValue.toString(), Integer.TYPE);
                                }
                            } catch (Exception e) {
                                log.error("转换参数失败", e);
                            }
                        }
                        //服务端 过滤
                        String conName = actionParam.getName();
                        if (conName.contains(".")) {
                            //指定过滤条件加在哪个参数中
                            String[] conNames = conName.split("\\.");
                            Object p = realParas.get(conNames[0]);
                            if (p != null) {
                                if (p instanceof JSONObject) {
                                    JSONObject pJson = (JSONObject) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof Map) {
                                    Map pJson = (Map) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof JSONArray) {
                                    JSONArray pJsonArray = (JSONArray) p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (oJson instanceof JSONObject) {
                                            JSONObject pJson = (JSONObject) oJson;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                } else if (p instanceof List) {
                                    List pJsonArray = (List) p;
                                    if (pJsonArray.size() == 0) {
                                        Map paraData = new HashMap();
                                        if (paramValue != null) {
                                            paraData.put(conNames[1], paramValue);
                                            pJsonArray.add(paraData);
                                        }
                                    } else {
                                        for (Object o : pJsonArray) {
                                            if (o instanceof Map) {
                                                Map pJson = (Map) o;
                                                if (paramValue != null) {
                                                    pJson.put(conNames[1], paramValue);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                Map paraData = new HashMap();
                                if (paramValue != null) {
                                    paraData.put(conNames[1], paramValue);
                                }

                                //根据元数据来判断入参是对象还是数组
                                if (!requestIsArray(requestFields, conNames[0])) {
                                    realParas.put(conNames[0], paraData);
                                } else {
                                    List<Object> o = new ArrayList<>();
                                    if (MapUtils.isNotEmpty(paraData)) {
                                        o.add(paraData);
                                    }
                                    realParas.put(conNames[0], o);
                                }
                            }

                        } else {
                            //直接加到参数中
                            realParas.put(actionParam.getName(), paramValue);
                        }
                    } else if ("ACTIVE_ROW_CONSTANT".equals(actionParam.getType()) || "CONSTANT".equals(actionParam.getType())) {
                        Object paramValue = actionParam.getValue();
                       /* if(paramValue ==  null){
                            continue;
                        }*/
                        if (actionParam.getTypeConverter() != null) {
                            try {
                                if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert(paramValue.toString(), Boolean.TYPE);
                                } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert(paramValue.toString(), Integer.TYPE);
                                }
                            } catch (Exception e) {
                                log.error("转换参数失败", e);
                            }
                        }
                        //服务端 过滤
                        String conName = actionParam.getName();
                        if (conName.contains(".")) {
                            //指定过滤条件加在哪个参数中
                            String[] conNames = conName.split("\\.");
                            Object p = realParas.get(conNames[0]);
                            if (p != null) {
                                if (p instanceof JSONObject) {
                                    JSONObject pJson = (JSONObject) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof Map) {
                                    Map pJson = (Map) p;
                                    pJson.put(conNames[1], paramValue);
                                } else if (p instanceof JSONArray) {
                                    JSONArray pJsonArray = (JSONArray) p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (oJson instanceof JSONObject) {
                                            JSONObject pJson = (JSONObject) oJson;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                } else if (p instanceof List) {
                                    List pJsonArray = (List) p;
                                    for (Object o : pJsonArray) {
                                        if (o instanceof Map) {
                                            Map pJson = (Map) o;
                                            pJson.put(conNames[1], paramValue);
                                        }
                                    }
                                }
                            } else {
                                Map paraData = new HashMap();
                                paraData.put(conNames[1], paramValue);
                                //根据元数据来判断入参是对象还是数组
                                if (!requestIsArray(requestFields, conNames[0])) {
                                    realParas.put(conNames[0], paraData);
                                } else {
                                    List<Object> o = new ArrayList<>();
                                    o.add(paraData);
                                    realParas.put(conNames[0], o);
                                }
                            }

                        } else {
                            //直接加到参数中
                            realParas.put(actionParam.getName(), paramValue);
                        }
                    }

                }
            }
        } else {
            //根据元数据来判断入参是对象还是数组
            if (MapUtils.isEmpty(dataSource.getParas())) {
                return;
            }
            if (CollectionUtils.isEmpty(dataSource.getActionParams())) {
                return;
            }
            Map<String, Object> realParas = dataSource.getParas();
            String conNames = dataSource.getActionParams().get(0).getName();
            if (conNames.contains(".")) {
                conNames = conNames.split("\\.")[0];
            }
            if (!requestIsArray(requestFields, conNames)) {
                if (!(realParas.get(conNames) instanceof List)) {
                    return;
                }
                List paras = JsonUtil.objectToJavaObject(realParas.get(conNames), List.class);
                if (paras != null && paras.size() > 0) {
                    Map parasMapOne = JsonUtil.objectToJavaObject(paras.get(0), Map.class);
                    dataSource.getParas().put(conNames, parasMapOne);
                }
            }
        }

    }

    /**
     * 针对现在入参可能是对象，可能是数组的情况下，利用元数据上的requestFields来判断入参是什么
     */
    private boolean requestIsArray(List<PcUiBotMetadataField> requestFields, String conNames) {
        if (!CollectionUtils.isEmpty(requestFields)) {
            for (PcUiBotMetadataField metadataField : requestFields) {
                if (conNames.equals(metadataField.getName())
                        && "object".equals(metadataField.getDataType())) {
                    return BooleanUtils.isTrue(metadataField.isArray());
                }
            }
        }
        return true;
    }

    /**
     * 重置组件多数据源数据 与 查询信息
     * null: 不用处理
     */
    public Map<String, Object> resetCmptMultipleDataSourceDataAndQueryInfo(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        try {
            return this.resetMultipleDataSourceDataAndQueryInfo(cmptContext, executeContext, dataSource, rawParam, queryInfo);
        } catch (Exception e) {
            log.error("reset cmpt multiple datasource data and query info error", e);
        }
        return null;
    }

    private Map<String, Object> resetMultipleDataSourceDataAndQueryInfo(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        // 判断是否需要替换数据源
        if (!this.judgeIsMultipleDataSource(cmptContext, executeContext, dataSource)) {
            return null;
        }
        // 获取组件数据源
        PcUiBotDataSourceSetDTO dataSourceSet = ZtbViewList.getCurrentDataSourceSet(cmptContext, dataSource, executeContext);
        if (dataSourceSet == null || Objects.equals(dataSourceSet.getMainDatasource(), executeContext.getMainDataSourceName())) {
            // 数据源为空 或 当前数据源为主数据源
            return null;
        }
        // 查询数据
        DigiwinAtdmQueryPageDataResult dataResult = this.dataQueryByDataset(cmptContext, executeContext, dataSource, dataSourceSet, rawParam, queryInfo);
        if (dataResult == null) {
            return null;
        }
        // 设置分页信息
        dataResult.getPageInfo().setPageCountSize(dataResult.getPageCountSize());
        queryInfo.setPageInfo(dataResult.getPageInfo());
        // 返回数据
        return dataResult.getPageData();
    }

    private DigiwinAtdmQueryPageDataResult dataQueryByDataset(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, PcUiBotDataSourceSetDTO dataSourceSet, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        // 构建参数
        Map<String, Object> parameter = this.buildRequestParamter(executeContext, dataSource, rawParam);
        // 查询数据
        DigiwinAtdmQueryPageDataReq bodyData = new DigiwinAtdmQueryPageDataReq()
                .setDataSourceSet(dataSourceSet)
                .setExecuteContext(executeContext)
                .setPageInfo(this.getPageInfo(queryInfo))
                .setParameter(parameter)
                .setSearchInfo(new ArrayList<>())
                .setSortInfo(new ArrayList<>());
        return digiwinAtdmProxyService.queryPageDataByDataset(AppRequestContext.getContextEntity().getLocale(), AppRequestContext.getContextEntity().getIamUserToken(), AppRequestContext.getContextEntity().getTenantId(), bodyData);
    }

    private PcUiBotPageInfo getPageInfo(PcUiBotQueryInfo queryInfo) {
        PcUiBotPageInfo pageInfo = new PcUiBotPageInfo();
        pageInfo.setPageNo(1);
        pageInfo.setPageSize(Optional.ofNullable(queryInfo).map(PcUiBotQueryInfo::getPageInfo).map(PcUiBotPageInfo::getPageSize).orElse(50));
        return pageInfo;
    }

}
