package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern;

import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：移动端 任务展示 参数封装信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PatternTaskInfo.java
 * @Author: wangjwc
 * @Date: created at 2023/6/12 13:25
 */
@Data
@Accessors(chain = true)
public class PatternTaskInfo implements Serializable {
    private static final long serialVersionUID = -8987813572457509043L;

    /**
     * pattern 类型
     *
     * @see PatternTypeEnum
     */
    private PatternTypeEnum patternType = PatternTypeEnum.STANDARD;

    /**
     * 移动端任务卡展示逻辑 任务卡类型
     *
     * @see CustomPatternTaskTypeEnum
     */
    private CustomPatternTaskTypeEnum customPatternTaskType = CustomPatternTaskTypeEnum.DEFAULT;

    private UiBotDesignerConfig uiBotDesignerConfig;

}
