package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewButtonTipConfig;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailV2Strategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.DesignerService;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：定制 PATTERN==CUSTOM 类型任务卡详情</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildCustomPatternTaskDetailStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/6/9 10:25
 */
@Slf4j
@Component("uiBotModelBuildCustomPatternTaskDetailStrategy")
public class UiBotModelBuildCustomPatternTaskDetailStrategy implements UiBotModelBuildStrategy, TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private DesignerService designerService;

    @Autowired
    private UiBotModelBuildMyTaskDetailStrategy uiBotModelBuildMyTaskDetailStrategy;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private UiBotModelBuildMyTaskDetailV2Strategy uiBotModelBuildMyTaskDetailV2Strategy;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        apiRequest.getPatternTaskInfo().setPatternType(PatternTypeEnum.CUSTOM);
        StopWatch stopWatch = new StopWatch("BuildCustomPatternTaskDetail");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {

        if (apiRequest.getExtraParameter() == null) {
            ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
            // line 场景下，H5调用任务详情接口时不会传递ExtraParameter和rawdata，故需要手动查询存入
            DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getDataId());
            apiExtraParameter.setAppCode(backlogDetail.getAppCode());
            apiExtraParameter.setTmTaskId(backlogDetail.getTmTaskId());
            apiExtraParameter.setTmActivityId(backlogDetail.getTmActivityId());
            apiRequest.setExtraParameter(apiExtraParameter);
        }

        // 获取任务详情的UiBot设计器配置 并 组装 apiRequest中的PatternTaskInfo
        UiBotDesignerConfig uiBotDesignerConfig = designerService.initPatternTaskInfoWithUiBotDesigner(apiRequest,
                apiRequest.getExtraParameter().getTmTaskId(), apiRequest.getExtraParameter().getTmActivityId(),
                pageSetting.getSystemDefault(), apiRequest.getExtraParameter().getAppCode());

        // 下面逻辑不能加stopWatch.start,因会与UiBotModelBuildMyTaskDetailStrategy中多次调用导致报错
        // 移动端任务卡展示逻辑 任务卡类型
        switch (apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
            case EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_TRUE:
                // 跳转移动端H5界面
                return this.buildJumpH5Page(pageSetting, apiRequest, uiBotDesignerConfig.getRawTaskActivityDefinition());
            case EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_FALSE:
                // wjw TODO: 2023/7/31 是否走V2版策略处理
//                // 使用 MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL 通用界面展示
//                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
//                pageSetting = pageSettingService.findById(apiRequest.getPageId());
//                break;
                return uiBotModelBuildMyTaskDetailV2Strategy.doActually(pageSetting, apiRequest);
            case NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE:
                // 展示任务标题，以及空组件提示。提示文案：『APP端暂不支持该定制任务，请到Web端查看』
                // 在对应的pageId=MOBILE_CUSTOM_PATTERN_TASK_DETAIL 中处理
                break;
            case NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_FALSE:
                // 使用 MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL 通用界面展示
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
                pageSetting = pageSettingService.findById(apiRequest.getPageId());
                break;
            case DEFAULT:
                // 默认类型 -- 不受设计器影响，通过移动配置的pageId打开flutter页面详情
                // 如果走到此默认类型，定制 PATTERN==CUSTOM 类型任务卡 使用 MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL 通用界面展示
                // 备注：实际场景下，定制 PATTERN==CUSTOM 类型任务卡 不会走到此case分支
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
                pageSetting = pageSettingService.findById(apiRequest.getPageId());
                break;
            default:
                break;
        }
        return uiBotModelBuildMyTaskDetailStrategy.doActually(pageSetting, apiRequest, stopWatch);
    }


    /**
     * 构建跳转外部H5页面Url
     *
     * @param pageSetting               页面原始配置
     * @param apiRequest                请求数据
     * @param rawTaskActivityDefinition KM任务定义原始配置数据
     * @return
     */
    public UiBotModel buildJumpH5Page(PageSetting pageSetting, ApiRequest apiRequest,
                                      KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<PageTaskRelation> pageTaskRelationList =
                this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case Webview.COMPONENT_TYPE:
                    Webview webview = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Webview.class);
                    this.initSetting(webview, apiRequest.getLocale());
                    webview.setUrl(this.buildUrl(apiRequest, pageTaskRelationList, rawTaskActivityDefinition));
                    pageData.put(layout.getSchema(), webview);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建跳转外部H5页面Url
     *
     * @param apiRequest                请求数据
     * @param pageTaskRelationList      任务与pageId关系配置数据
     * @param rawTaskActivityDefinition KM任务定义原始配置数据
     * @return
     */
    private String buildUrl(ApiRequest apiRequest, List<PageTaskRelation> pageTaskRelationList,
                            KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        String url = "";
        Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                        pageTaskRelation -> {
                            Boolean customPattern = pageTaskRelation.matchInPatternAndCategory(
                                    apiRequest.getExtraParameter().getTmPattern(), apiRequest.getExtraParameter().getTmCategory());
                            // 定制 PATTERN==CUSTOM 类型任务卡详情 pageID
                            boolean customPage = PageSettingIdPresetEnum.MOBILE_CUSTOM_PATTERN_TASK_DETAIL.name().equals(pageTaskRelation.getPageId());
                            return customPattern && customPage;
                        })
                .findFirst();
        if (!optPageTaskRelationPattern.isPresent()) {
            return url;
        }
        url = StringUtil.valueOf(optPageTaskRelationPattern.get().getUrl());
        url = url
                .replaceAll("\\$\\{customTaskTemplateUrl}",
                        sysEnvConfig.getCustomTaskTemplateUrl()
                                .replace("{appId}", this.getAppId(rawTaskActivityDefinition)))
                .replaceAll("\\$\\{tmActivityId}", apiRequest.getExtraParameter().getTmActivityId())
                .replaceAll("\\$\\{tmTaskId}", apiRequest.getExtraParameter().getTmTaskId())
                .replaceAll("\\$\\{backlogId}", StringUtil.valueOf(apiRequest.getDataId()))
                .replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken())
                .replaceAll("\\$\\{tenantId}", apiRequest.getTenantId());
        return url;
    }

    /**
     * 从 KM 任务定义原始配置数据中 获取所属应用信息
     *
     * @param rawTaskActivityDefinition KM任务定义原始配置数据
     * @return
     */
    private String getAppId(KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        String appId = "";
        if (null == rawTaskActivityDefinition) {
            return appId;
        }
        // 应用名称
        String appName = rawTaskActivityDefinition.getString("appName");
        // 应用code
        String application = rawTaskActivityDefinition.getString("application");
        if (!StringUtils.hasLength(application)) {
            return appId;
        }
        // 字母转小写
        return appId.toLowerCase();

    }

    private void initSetting(Webview webview, String locale) {
        if (StringUtils.hasLength(webview.getTitle())) {
            webview.setTitle(localeService.getLanguageValue(locale, webview.getTitle()));
        }
        WebviewButtonTipConfig buttonTipConfig = webview.getButtonTipConfig();
        if (null != buttonTipConfig) {
            webview.getButtonTipConfig().setText(localeService.getLanguageValue(locale, buttonTipConfig.getText()));
            Action action = buttonTipConfig.getAction();
            if (action != null) {
                if (StringUtils.hasLength(action.getJumpPageTitle())) {
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                }
                if (StringUtils.hasLength(action.getToastMsg())) {
                    action.setToastMsg(localeService.getLanguageValue(locale, action.getToastMsg()));
                }
                if (StringUtils.hasLength(action.getRequestUrl())) {
                    action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                }
            }
        }
        this.initButton(locale, webview.getButtonList());
    }

    private void initButton(String locale, List<BottomButtonDigiwinAthena> buttonList) {
        if (!CollectionUtils.isEmpty(buttonList)) {
            for (BottomButtonDigiwinAthena button : buttonList) {
                if (StringUtils.hasLength(button.getName())) {
                    button.setName(localeService.getLanguageValue(locale, button.getName()));
                }
                if (StringUtils.hasLength(button.getSubName())) {
                    button.setSubName(localeService.getLanguageValue(locale, button.getSubName()));
                }
                Action action = button.getAction();
                if (action != null) {
                    if (StringUtils.hasLength(action.getJumpPageTitle())) {
                        action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                    }
                    if (StringUtils.hasLength(action.getToastMsg())) {
                        action.setToastMsg(localeService.getLanguageValue(locale, action.getToastMsg()));
                    }
                    if (StringUtils.hasLength(action.getRequestUrl())) {
                        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                    }
                }
            }
        }
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_PATTERN_TASK;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        // 头部：任务标题
        String schema = "uiBot__activity";
        UiBotLayout layout = new UiBotLayout();
        layout.setType(TitleBody.COMPONENT_TYPE);
        layout.setSchema(schema);
        uiBotModel.getLayout().add(layout);
        // wjw FIXME: 2023/6/13 isApproval先传递false，后面存在其它场景在根据tmCategory值，判断具体值
        uiBotModel.getPageData().put(schema, ModuleUtils.buildTitle(pcUiBotModel,
                (Map<String, Object>) pcUiBotModel.getPageData().get(schema),
                (DigiwinAtmcBacklogDetail) args[0], apiRequest, false, false));
        return uiBotModel;
    }
}
