package com.digiwin.mobile.mobileuibot.dashboard;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DashboardContentBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/11/22 20:16
 */
@Component("dashboardContentBuildStrategyFactory")
public class DashboardContentBuildStrategyFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, DashboardContentBuildStrategy>
            DASHBOARD_CONTENT_BUILD_STRATEGY_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public DashboardContentBuildStrategy get(String key) {
        return DASHBOARD_CONTENT_BUILD_STRATEGY_MAP.get(key);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 DashboardContentBuildStrategy 注册到 DASHBOARD_CONTENT_BUILD_STRATEGY_MAP
        this.appContext.getBeansOfType(DashboardContentBuildStrategy.class).values().forEach(
                strategy -> DASHBOARD_CONTENT_BUILD_STRATEGY_MAP.put(strategy.getType(), strategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        this.appContext = applicationContext;
    }
}
