package com.digiwin.mobile.mobileuibot.dashboard;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfig;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfigService;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppReportConfig;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorization;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorizationResponse;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 工作台服务类
 *
 * @author zhangjj
 * @date 2022/4/18 2:07 PM
 */
@Service
public class DashboardServiceImpl implements DashboardService {

    private Logger logger = LoggerFactory.getLogger(DashboardServiceImpl.class);

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private MobileAppConfigService mobileAppConfigService;

    @Autowired
    private DashboardContentOrderService dashboardContentOrderService;

    @Autowired
    private DashboardContentBuildStrategyFactory dashboardContentBuildStrategyFactory;

    @Override
    public List<CustomContent> generateDashboardCustomContent(String iamUserToken,
                                                              String locale,
                                                              String clientId,
                                                              boolean recommend, Boolean isOnly) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("GetData From IAM API");
        // 通过CAC查询商品购买情况
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        stopWatch.stop();
        stopWatch.start("GetData From CAC API");
        DigiwinCacTenantAuthorizationResponse digiwinCacTenantAuthorizationResponse = new DigiwinCacTenantAuthorizationResponse();
        if (analyzedToken != null && analyzedToken.getTenantId() != null) {
            digiwinCacTenantAuthorizationResponse =
                    this.digiwinCacProxyService.findTenantAuthorizations(analyzedToken.getTenantId(),
                            iamUserToken);
        }
        stopWatch.stop();

        List<CustomContent> customContentList =
                new ArrayList<>(digiwinCacTenantAuthorizationResponse.size());

        List<MobileAppConfig> mobileAppConfigs = this.mobileAppConfigService.listMobileAppConfigsBelongDigiwinCompanyId();
        for (DigiwinCacTenantAuthorization digiwinCacTenantAuthorization : digiwinCacTenantAuthorizationResponse) {
            String goodsCode = digiwinCacTenantAuthorization.getCode();
            String goodsDisplayName = digiwinCacTenantAuthorization.getDisplayName();
            // FIXME 硬编码。先依应用商品编码判断：如果遇到code是Athena的，表示是Athena平台，直接跳过
            if (StringUtil.SOURCE_ATHENA.equalsIgnoreCase(goodsCode)) {
                continue;
            }
            if (digiwinCacTenantAuthorization.isExpired()) {
                logger.debug(
                        "CAC authorization expired...userId is {}, tenantId is {}, tenantName is {}, "
                                + "goodsCode is {}, goodsDisplayName is {}", analyzedToken.getId(),
                        analyzedToken.getTenantId(), analyzedToken.getTenantName(), goodsCode,
                        goodsDisplayName);
                continue;
            }
            logger.debug("CAC authorization valid...userId is {}, tenantId is {}, tenantName is {}, "
                            + "goodsCode is {}, goodsDisplayName is {}", analyzedToken.getId(),
                    analyzedToken.getTenantId(), analyzedToken.getTenantName(), goodsCode,
                    goodsDisplayName);
            Optional<MobileAppConfig> optMobileAppConfig =
                    mobileAppConfigs.stream().filter(mobileAppConfig ->
                                    goodsCode.equals(mobileAppConfig.getAppCode())
                                            && mobileAppConfig.validWithAppEnvType(AppContext.getEnvType())
                            )
                            .findFirst();
            if (!optMobileAppConfig.isPresent()) {
                continue;
            }
            MobileAppConfig mobileAppConfig = optMobileAppConfig.get();
            boolean hasReport = Optional.ofNullable(mobileAppConfig)
                    .map(MobileAppConfig::getReportConfig)
                    .map(MobileAppReportConfig::hasReport)
                    .orElse(false);
            if (hasReport) {
                DashboardContentBuildStrategy buildStrategy =
                        this.dashboardContentBuildStrategyFactory.get(DashboardContentBuildStrategy.REPORT_CONTENT);
                if (null != buildStrategy) {
                    CustomContent customContent = buildStrategy.buildDashboardContent(
                            iamUserToken, locale, clientId, mobileAppConfig, recommend);
                    customContent.getSysParam().put("tenantId", analyzedToken.getTenantId());
                    customContent.getSysParam().put("userId", analyzedToken.getId());
                    customContentList.add(customContent);
                }
            }
        }
        if (customContentList.isEmpty() && isOnly) {
            logger.debug("Noting authorizable found in dashboard, create DEFAULT EMPTY content..."
                            + "userId is {}, tenantId is {}, tenantName is {}", analyzedToken.getId(),
                    analyzedToken.getTenantId(), analyzedToken.getTenantName());
            CustomContent customContent =
                    CustomContent.create(locale, clientId, iamUserToken, "",
                            AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/empty", recommend);
            customContentList.add(customContent);
        }
        // 按照一定算法决定商品对应的自定义内容的呈现顺序
        customContentList = this.dashboardContentOrderService.orderContentList(customContentList);

        return customContentList;
    }
}
