package com.digiwin.mobile.mobileuibot.dashboard;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfig;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * <p>功能描述：工作台报表内容生成的策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ReportDashboardContentBuildStrategy
 * @Author: Zaregoto
 * @Date: 2022/4/22 12:10
 */
@Component("reportDashboardContentBuildStrategy")
public class ReportDashboardContentBuildStrategy implements DashboardContentBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(ReportDashboardContentBuildStrategy.class);

    @Override
    public String getType() {
        return DashboardContentBuildStrategy.REPORT_CONTENT;
    }

    @Override
    public CustomContent buildDashboardContent(String iamUserToken, String locale, String clientId,
                                               MobileAppConfig mobileAppConfig, boolean recommend) {
        String companyId = mobileAppConfig.getCompanyId();
        if (MobileAppConfig.DIGIWIN_COMPANY_ID.equals(companyId)) {
            return getDigiwinReportContent(iamUserToken, locale, clientId, mobileAppConfig, recommend);
        }
        return null;
    }

    @NotNull
    private CustomContent getDigiwinReportContent(String iamUserToken, String locale, String clientId,
                                                  MobileAppConfig mobileAppConfig, boolean recommend) {
        String goodsCode = mobileAppConfig.getAppCode();
        String serviceUrl = "";
        // 是否与TBB集成使用旧方式。旧方式是指直接调用TBB的API，新方式指的是直接调用Athena平台的API
        boolean getReportInOldWay = true;
        if ("PCC".equals(goodsCode) || "PCM".equals(goodsCode)) {
            serviceUrl = AppContext.getApiUrlSetting().getTbbApiUrl() + "/tbb-system/app_guide/panel";
        } else {
            getReportInOldWay = false;
            serviceUrl = AppContext.getApiUrlSetting().getAppmetadataUrl() + DigiwinKnowledgeMapsProxyService.DATAMAP_DOMAIN_API_PREFIX
                    + "/record/tBBReports?mode=mobile&productCode=" + goodsCode;
        }
        CustomContent customContent = null;
        try {
            customContent = CustomContent.create(locale, clientId,
                    iamUserToken, goodsCode,
                    AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/outer?"
                            + "locale=" + locale
                            + "&useDap=" + "true"
                            + "&getReportInOldWay=" + getReportInOldWay
                            + "&serviceUrl=" + URLEncoder.encode(serviceUrl, "utf-8"),
                    recommend);
        } catch (UnsupportedEncodingException e) {
            logger.error("UrlEncode Error...Msg is {}", e.getMessage());
            e.printStackTrace();
        }
        return customContent == null ? CustomContent.createEmpty() : customContent;
    }
}
