package com.digiwin.mobile.mobileuibot.dashboard;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceTitleStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcWorkbench;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：工作台页面构建策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UibotModelBuildDashboardStrategy
 * @Author: Zaregoto
 * @Date: 2021/9/9 21:41
 */
@Slf4j
@Component("uibotModelBuildDashboardStrategy")
public class UiBotModelBuildDashboardStrategy implements UiBotModelBuildStrategy {

    private static final Integer REPORT_SHOW_SIZE = 2;

    private static final String DASHBOARD_VERSION_V2 = "v2";

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private RecommendService recommendService;

    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private AppEntranceRecordService recordService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private UiBotModelBuildDashboardV2Strategy uiBotModelBuildDashboardV2Strategy;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doBefore(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

//    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
//                                  StopWatch stopWatch) {
//        /**
//         * 1. 调用CAC查询当前用户所在的租户购买的商品
//         * 2. 根据返回的每个商品生成一个对应的“自定义内容组件”，并通过一个算法，决定呈现的顺序
//         * 3. 查找传入的PageSetting，判断是否有自定义的页面配置。如果有自定义页面配置，则解析配置中的组件，加入到layout中
//         * 5. 返回最终的UiBotModel
//         */
//        //应用
//        List<AppEntrance> appEntranceList = recommendService.getAllAppEntrance(apiRequest.getIamUserToken(),
//                apiRequest.getUserId(), apiRequest.getLocale());
//        //报表区域  先判断是否有报表
//        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(apiRequest.getClientId(),
//                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
//        if (CollectionUtils.isEmpty(appEntranceList) && CollectionUtils.isEmpty(tmDataList)) {
//            return UiBotModel.createCustomContentWelcomeModel(apiRequest.getLocale());
//        }
//        int reportSize = 0;
//        String customName = localeService.getLanguageValue(apiRequest.getLocale(), "报表");
//        CustomGroup customGroup = new CustomGroup();
//        customGroup.setName(customName);
//        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
//        CustomGroupContent content = new CustomGroupContent();
//        List<UiBotLayout> contentUiBotLayouts = new ArrayList<>(REPORT_SHOW_SIZE);
//        UiBotPageData contentPageData = new UiBotPageData();
//        UiBotLayout uiBotLayout = new UiBotLayout();
//        String schema = UUIDUtil.getUuid();
//        uiBotLayout.setType(Apposition.COMPONENT_TYPE);
//        uiBotLayout.setSchema(schema);
//        Apposition apposition = new Apposition();
//        apposition.setPadding(24d);
//        apposition.setColumns(REPORT_SHOW_SIZE);
//        List<AppositionData> data = new ArrayList(REPORT_SHOW_SIZE);
//        contentUiBotLayouts.add(uiBotLayout);
//
//
//        // TODO 将自定义页面配置中的组件追加到页面layout中。如果没有，则以购买商品的查询结果作为layout
//        PageSetting actualPageSetting = new PageSetting();
//        actualPageSetting.setSystemDefault(pageSetting.getSystemDefault());
//        actualPageSetting.setPageTitle(pageSetting.getPageTitle());
//
//        UiBotPageData pageData = new UiBotPageData();
//        List<UiBotLayout> uiBotLayouts = new ArrayList<>();
//        Boolean isMore = false;
//        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
//            if (!CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
//                for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
//                    AppositionData appositionData = new AppositionData();
//                    if (dataReport.isAllow()) {
//                        appositionData.setComponentType(Button.COMPONENT_TYPE);
//                        if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
//                            appositionData.setData(BottomButtonDigiwinAthena.createABIReportButton(
//                                    dataReport.getName(), dataReport, dataReport.getCode()));
//                            data.add(appositionData);
//                        } else if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) {

    ////                            appositionData.setData(BottomButtonDigiwinAthena.createTBBReportButton(dataReport.getName()));
//                        }
//                        reportSize++;
//                    } else {
//                        if (reportSize >= REPORT_SHOW_SIZE) {
//                            isMore = true;
//                        }
//                    }
//                }
//            }
//        }
//        if (reportSize != 0) {
//            List<String> reportId = recordService.getReportAppIdListByUserId(apiRequest.getUserId(),
//                    apiRequest.getTenantId());
//            List<AppositionData> newData = new ArrayList<>(2);
//            if (reportId != null && reportId.size() >= REPORT_SHOW_SIZE) {
//                for (int i = 0; i < REPORT_SHOW_SIZE; i++) {
//                    for (AppositionData appositionData : data) {
//                        Button button = (Button) appositionData.getData();
//                        if (reportId.get(i) != null && reportId.get(i).contains(button.getId())) {
//                            newData.add(appositionData);
//                            break;
//                        }
//                    }
//                }
//            } else if (reportId != null && reportId.size() == 1) {
//                for (int i = 0; i < reportId.size(); i++) {
//                    for (int j = 0; j < data.size(); j++) {
//                        Button button = (Button) data.get(j).getData();
//                        if (reportId.get(i) != null && reportId.get(i).contains(button.getId())) {
//                            newData.add(data.get(j));
//                            if (j != 0) {
//                                newData.add(data.get(0));
//                            } else {
//                                newData.add(data.get(1));
//                            }
//                            break;
//                        }
//                    }
//                }
//            } else {
//                for (int i = 0; i < REPORT_SHOW_SIZE; i++) {
//                    newData.add(data.get(i));
//                }
//            }
//            apposition.setDatas(newData);
//            contentPageData.put(schema, apposition);
//            content.setPageData(contentPageData);
//            content.setLayout(contentUiBotLayouts);
//            customGroup.setContent(content);
//
//            customGroup.setUseExpand(false);
//            HiddenConfig hiddenConfig = new HiddenConfig();
//            customGroup.setHiddenConfig(hiddenConfig);
//            if (isMore) {
//                Button viewMoreButton = new Button();
//                viewMoreButton.setName(localeService.getLanguageValue(apiRequest.getLocale(), "查看更多") + ">");
//                Action action = new Action();
//                action.setJumpPageTitle(customName);
//                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPORT_LIST.toString());
//                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
//                viewMoreButton.setAction(action);
//                customGroup.setViewMore(viewMoreButton);
//            }
//
//            UiBotLayout customLayout = new UiBotLayout();
//            customLayout.setType(CustomGroup.COMPONENT_TYPE);
//            customLayout.setSchema(schema);
//            uiBotLayouts.add(customLayout);
//            pageData.put(schema, customGroup);
//        }
//
//
//        for (AppEntrance appEntrance : appEntranceList) {
//            String uuid = UUIDUtil.getUuid();
//            UiBotLayout layout = new UiBotLayout();
//            layout.setType(AppEntrance.COMPONENT_TYPE);
//            layout.setSchema(uuid);
//            uiBotLayouts.add(layout);
//            pageData.put(uuid, appEntrance);
//        }
//        //发起项目
//        List<AppFunctionTouchable> appList = this.projectService.getLaunchableProjectAppList(apiRequest.getIamUserToken(),
//                actualPageSetting.getTenantId(), apiRequest.getLocale());
//        if (!CollectionUtils.isEmpty(appList)) {
//            AppEntrance appEntrance = new AppEntrance();
//            appEntrance.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), "手动发起项目"));
//            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
//            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
//            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
//            appEntrance.setAppList(appList);
//            String uuid = UUIDUtil.getUuid();
//            UiBotLayout layout = new UiBotLayout();
//            layout.setType(AppEntrance.COMPONENT_TYPE);
//            layout.setSchema(uuid);
//            uiBotLayouts.add(layout);
//            pageData.put(uuid, appEntrance);
//        }
//
//        UiBotModel actualPageModel = new UiBotModel(uiBotLayouts);
//        actualPageSetting.setPageModel(actualPageModel);
//
//        // 拼成最终数据
//        stopWatch.start("Build Common Page Model");
//        UiBotModel uiBotModel =
//                this.uiBotModelBuildService.buildModel(actualPageSetting, pageData, true);
//        stopWatch.stop();
//
//        return uiBotModel;
//    }

    private UiBotModel doBefore(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (Objects.equals(DASHBOARD_VERSION_V2, apiRequest.getDashboardVersion())) {
            return uiBotModelBuildDashboardV2Strategy.doActually(pageSetting, apiRequest, stopWatch);
        }
        return this.doActually(pageSetting, apiRequest, stopWatch);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        /**
         * 1. 调用CAC查询当前用户所在的租户购买的商品
         * 2. 根据返回的每个商品生成一个对应的“自定义内容组件”，并通过一个算法，决定呈现的顺序
         * 3. 查找传入的PageSetting，判断是否有自定义的页面配置。如果有自定义页面配置，则解析配置中的组件，加入到layout中
         * 5. 返回最终的UiBotModel
         */
        // TODO 将自定义页面配置中的组件追加到页面layout中。如果没有，则以购买商品的查询结果作为layout
        PageSetting actualPageSetting = new PageSetting();
        actualPageSetting.setSystemDefault(pageSetting.getSystemDefault());
        actualPageSetting.setPageTitle(pageSetting.getPageTitle());

        UiBotPageData pageData = new UiBotPageData();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>();

        // 是否存在报表权限与数据
        boolean hasReportModule = false;
//        // wjw FIXME: 2023/4/17 S4 隐藏报表区域
//        if (!AppEnvTypeEnum.PRODUCTION.getEnvType().equals(AppContext.getEnvType())) {
        //报表区域
        String tmSchema = UUIDUtil.getUuid();
        List<CustomGroup> customGroups = this.getTmReportList(tmSchema, apiRequest);
        for (CustomGroup customGroup : customGroups) {
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType(CustomGroup.COMPONENT_TYPE);
            customLayout.setSchema(tmSchema);
            uiBotLayouts.add(customLayout);
            pageData.put(tmSchema, customGroup);
            hasReportModule = true;
        }
//        }
        // 手动发起项目
        List<AppEntrance> launchableProjectList = this.getLaunchableProject(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale());
        for (AppEntrance appEntrance : launchableProjectList) {
            String uuid = UUIDUtil.getUuid();
            CustomGroup customGroup = this.createCustomGroup(uuid, appEntrance);
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType(CustomGroup.COMPONENT_TYPE);
            customLayout.setSchema(uuid);
            uiBotLayouts.add(customLayout);
            pageData.put(uuid, customGroup);
        }


        // 智能入口
        List<AppEntrance> appEntranceList = recommendService.getAllAppEntrance(apiRequest.getIamUserToken(),
                apiRequest.getUserId(), apiRequest.getLocale());
        //判断是否司机角色
        log.debug("apiRequest.getIsZtbDriver():" + apiRequest.getIsZtbDriver());
        Boolean flag = Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false);
        for (AppEntrance appEntrance : appEntranceList) {
            List<AppFunctionTouchable> appList = appEntrance.getAppList();
            log.debug("appList:" + JSONUtil.toJsonStr(appList));
            if (!CollectionUtils.isEmpty(appList)) {
                List<AppFunctionTouchable> newAppList = new ArrayList<>();
                for (AppFunctionTouchable touchable : appList) {
                    if ("srm-loading_srm-loading".equalsIgnoreCase(touchable.getId())) {
                        if (!flag && (StrUtil.equals(touchable.getAction().getDataId(), "shipper") || StrUtil.equals(touchable.getAction().getDataId(), "receiver"))) {
                            touchable.setName(localeService.getLanguageValue(apiRequest.getLocale(), touchable.getName()));
                            Map<String, Object> params = new HashMap<>(1);
                            params.put("module_type", "2");
                            String url = digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(),
                                    apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId()
                                    + "&transportType=" + (StrUtil.equals(touchable.getAction().getDataId(), "shipper") ? "1" : "2");
                            touchable.getAction().setRequestUrl(url);
                            newAppList.add(touchable);
                        }
                        if (flag && StrUtil.equals(touchable.getAction().getDataId(), "driver")) {
                            touchable.setName(localeService.getLanguageValue(apiRequest.getLocale(), touchable.getName()));
                            Map<String, Object> params = new HashMap<>(1);
                            params.put("module_type", "2");
                            String url = digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(),
                                    apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId();
                            touchable.getAction().setRequestUrl(url);
                            newAppList.add(touchable);
                        }
                    } else if ("TipBiuBI_datasource".equalsIgnoreCase(touchable.getId())) {
                        // TBB报表
                        if (StringUtils.hasLength(Optional.ofNullable(touchable.getAction()).map(Action::getRequestUrl).orElse(null))) {
                            String requestUrl = touchable.getAction().getRequestUrl()
                                    .replaceAll("\\$\\{locale}", apiRequest.getLocale())
                                    .replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken());
                            touchable.getAction().setRequestUrl(requestUrl);
                        }
                        newAppList.add(touchable);
                    } else if ("Athena_GLOBAL_INFORMATION".equals(touchable.getId())) {
                        // 存在报表权限与数据，显示全局资讯入口
                        if (hasReportModule) {
                            newAppList.add(touchable);
                        }
                    } else {
                        newAppList.add(touchable);
                    }
                }
                log.debug("newAppList:" + JSONUtil.toJsonStr(newAppList));
                appEntrance.setAppList(newAppList);
            }

            String uuid = UUIDUtil.getUuid();
            CustomGroup customGroup = this.createCustomGroup(uuid, appEntrance);
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType(CustomGroup.COMPONENT_TYPE);
            customLayout.setSchema(uuid);
            uiBotLayouts.add(customLayout);
            pageData.put(uuid, customGroup);
        }

        //拥有绿色智机项目权限，新建异步组件
        if (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset()) {
            String uuid = UUIDUtil.getUuid();
            CustomContent customContent = CustomContent.create(apiRequest.getLocale(), apiRequest.getClientId(),
                    apiRequest.getIamUserToken(), "",
                    AppContext.getBaseUrl() + "/machine/preset/workBench/queryAppJob", true);
            UiBotLayout customContentLayout = new UiBotLayout();
            customContentLayout.setType(CustomContent.COMPONENT_TYPE);
            customContentLayout.setSchema(uuid);
            uiBotLayouts.add(customContentLayout);
            pageData.put(uuid, customContent);
        }

//        // wjw FIXME: 2024/8/26 先控制dev显示
//        if (AppEnvTypeEnum.DEVELOP.getEnvType().equals(AppContext.getEnvType())) {
//            // 移动工作台
//            List<AppEntrance> workbenchList = this.getWorkbenchList(apiRequest);
//            for (AppEntrance appEntrance : workbenchList) {
//                String uuid = UUIDUtil.getUuid();
//                CustomGroup customGroup = this.createCustomGroup(uuid, appEntrance);
//                UiBotLayout customLayout = new UiBotLayout();
//                customLayout.setType(CustomGroup.COMPONENT_TYPE);
//                customLayout.setSchema(uuid);
//                uiBotLayouts.add(customLayout);
//                pageData.put(uuid, customGroup);
//            }
//        }
        if (CollectionUtils.isEmpty(uiBotLayouts)) {
            return UiBotModel.createCustomContentWelcomeModel(apiRequest.getLocale());
        }

        UiBotModel actualPageModel = new UiBotModel(uiBotLayouts);
        actualPageModel.setPageBackgroudColor(pageSetting.getPageModel().getPageBackgroudColor());
        actualPageSetting.setPageModel(actualPageModel);

        // 拼成最终数据
        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel =
                this.uiBotModelBuildService.buildModel(actualPageSetting, pageData, true);
        stopWatch.stop();

        return uiBotModel;
    }

    private List<CustomGroup> getTmReportList(String schema, ApiRequest apiRequest) {
        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty(tmDataList)) {
            return Collections.emptyList();
        }

        List<AppositionData> data = new ArrayList<>(REPORT_SHOW_SIZE);
        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            if (CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                continue;
            }
            for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                AppositionData appositionData = new AppositionData();
                if (dataReport.isAllow()) {
                    appositionData.setComponentType(Button.COMPONENT_TYPE);
                    //M2需求-过滤ABI报表
                    //if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
                    //    appositionData.setData(BottomButtonDigiwinAthena.createABIReportButton(
                    //            dataReport.getName(), dataReport, dataReport.getCode()));
                    //    data.add(appositionData);
                    //} else
                    if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) {
                        appositionData.setData(BottomButtonDigiwinAthena.createTBBReportButton(
                                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                                Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()),
                                dataReport.getName()));
                        data.add(appositionData);
                    }
                }
            }
        }
        if (data.size() == 0) {
            return Collections.emptyList();
        }
        boolean isMore = false;
        if (data.size() >= REPORT_SHOW_SIZE) {
            isMore = true;
        }

        CustomGroup customGroup = new CustomGroup();
        String customName = localeService.getLanguageValue(apiRequest.getLocale(), "报表");
        customGroup.setName(customName);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> contentUiBotLayouts = new ArrayList<>(REPORT_SHOW_SIZE);
        UiBotPageData contentPageData = new UiBotPageData();
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(Apposition.COMPONENT_TYPE);
        uiBotLayout.setSchema(schema);
        Apposition apposition = new Apposition();
        apposition.setPadding(24d);
        apposition.setColumns(REPORT_SHOW_SIZE);
        contentUiBotLayouts.add(uiBotLayout);

        List<String> reportId = recordService.getReportAppIdListByUserId(apiRequest.getUserId(),
                apiRequest.getTenantId());
        List<AppositionData> newData = new ArrayList<>(2);
        if (reportId != null && reportId.size() >= REPORT_SHOW_SIZE) {
            for (int i = 0; i < REPORT_SHOW_SIZE; i++) {
                for (AppositionData appositionData : data) {
                    Button button = (Button) appositionData.getData();
                    if (reportId.get(i) != null && reportId.get(i).contains(button.getId())) {
                        newData.add(appositionData);
                        break;
                    }
                }
            }
        } else if (reportId != null && reportId.size() == 1) {
            for (int i = 0; i < reportId.size(); i++) {
                for (int j = 0; j < data.size(); j++) {
                    Button button = (Button) data.get(j).getData();
                    if (reportId.get(i) != null && reportId.get(i).contains(button.getId())) {
                        newData.add(data.get(j));
                        if (j != 0) {
                            newData.add(data.get(0));
                        } else {
                            newData.add(data.get(1));
                        }
                        break;
                    }
                }
            }
        }
//        else {
//            for (int i = 0; i < REPORT_SHOW_SIZE; i++) {
//                newData.add(data.get(i));
//            }
//        }
        if (newData.size() < REPORT_SHOW_SIZE) {
            for (int i = 0; i < REPORT_SHOW_SIZE; i++) {
                if (data.size() > i) {
                    newData.add(data.get(i));
                }
            }
        }
        apposition.setDatas(newData);
        contentPageData.put(schema, apposition);
        content.setPageData(contentPageData);
        content.setLayout(contentUiBotLayouts);
        customGroup.setContent(content);
        customGroup.setUseExpand(false);
        HiddenConfig hiddenConfig = new HiddenConfig();
        customGroup.setHiddenConfig(hiddenConfig);
        if (isMore) {
            Button viewMoreButton = new Button();
            viewMoreButton.setName(localeService.getLanguageValue(apiRequest.getLocale(), "查看更多") + ">");
            Action action = new Action();
            action.setJumpPageTitle(customName);
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPORT_LIST.toString());
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            viewMoreButton.setAction(action);
            customGroup.setViewMore(viewMoreButton);
        }
        return Collections.singletonList(customGroup);
    }

    private List<AppEntrance> getLaunchableProject(String iamUserToken, String tenantId, String locale) {
        List<LaunchableProject> accessibleLaunchableProjectList =
                this.projectService.getLaunchableProjectList(iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty(accessibleLaunchableProjectList)) {
            return Collections.emptyList();
        }
        AppEntrance appEntrance = new AppEntrance();
        appEntrance.setTitle(localeService.getLanguageValue(locale, "手动发起项目"));
        appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
        appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
        appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
        List<AppFunctionTouchable> appList = accessibleLaunchableProjectList.stream()
                .map(project -> {
                    AppFunctionTouchable appFunctionTouchable = new AppFunctionTouchable();
                    appFunctionTouchable.setId(project.getCode());
                    //处理智慧检料名字
                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
                        appFunctionTouchable.setName(project.getName().substring(0, 4));
                    } else {
                        appFunctionTouchable.setName(project.getName());
                    }
                    appFunctionTouchable.setIconData(null);
                    appFunctionTouchable.setIconColor(null);
                    Action<Map<String, Object>> action = new Action<>();

                    // 发起项目设计器跳转需要的信息
                    if (BooleanUtils.isTrue(project.getIsDesigner())) {
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                        action.setJumpPageTitle(project.getName());
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("project_introduce", project.getDesc());
                        rawData.put("project_name", project.getName());
                        rawData.put("dataId", project.getCreateSuffix());
                        action.setRawData(rawData);
                    } else {
                        if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                            Action rawDataAction = new Action();
                            rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            rawDataAction.setJumpPageTitle(project.getName());
                            rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            rawDataAction.setDataId(project.getCreateSuffix());
                            Map<String, Object> rawData = new HashMap<>(2);
                            rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                            rawData.put("action", rawDataAction);
                            action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                            action.setRawData(rawData);
                        } else {
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            action.setJumpPageTitle(project.getName());
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            action.setDataId(project.getCreateSuffix());
                        }
                    }

                    appFunctionTouchable.setAction(action);
                    //处理智慧检料图标
                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
                        appFunctionTouchable.setImage("IMAGE_" + ProjectConstant.LAUNCH_EXCLUDED_PROJECT_TM_ACTIVITY_ID);
                    } else {
                        appFunctionTouchable.setImage("IMAGE_" + project.getCreateSuffix());
                    }

                    return appFunctionTouchable;
                }).collect(Collectors.toList());
        appEntrance.setAppList(appList);
        return Collections.singletonList(appEntrance);
    }

    private List<AppEntrance> getWorkbenchList(ApiRequest apiRequest) {
        List<AppEntrance> appEntranceList = new ArrayList<>();
        DigiwinAudcWorkbench audcWorkbench = audcProxyService.getWorkbenchList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (audcWorkbench == null) {
            return appEntranceList;
        }
        List<DigiwinAtmcTmData> dataList = audcWorkbench.getDataList();
        if (CollectionUtils.isEmpty(dataList)) {
            return appEntranceList;
        }
        dataList.stream().flatMap(data -> data.getGroupList().stream()).forEach(group -> {
            AppEntrance appEntrance = new AppEntrance();
            appEntrance.setTitle(group.getGroupName());
            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
            List<AppFunctionTouchable> appList = group.getBaseItemDtoList().stream()
                    .filter(DigiwinAtmcTmDataReport::isAllow)
                    .map(workbench -> {
                        AppFunctionTouchable touchable = new AppFunctionTouchable();
                        touchable.setId(workbench.getAppCode() + "_" + workbench.getCode());
                        touchable.setName(workbench.getName());
                        touchable.setIconData(null);
                        touchable.setIconColor(null);
                        touchable.setIconBase64(workbench.getIcon());

                        Action<Map<String, Object>> action = new Action<>();
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_PAGE.toString());
                        action.setJumpPageTitle(workbench.getName());
                        action.setDataId(workbench.getCode());

                        touchable.setAction(action);
                        return touchable;
                    }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(appList)) {
                return;
            }
            appEntrance.setAppList(appList);
            appEntranceList.add(appEntrance);
        });
        return appEntranceList;
    }

    private CustomGroup createCustomGroup(String schema, AppEntrance appEntrance) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(appEntrance.getTitle());
        appEntrance.setTitle("");
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> contentUiBotLayouts = new ArrayList<>();
        UiBotPageData contentPageData = new UiBotPageData();
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(AppEntrance.COMPONENT_TYPE);
        uiBotLayout.setSchema(schema);
        contentUiBotLayouts.add(uiBotLayout);
        contentPageData.put(schema, appEntrance);

        content.setPageData(contentPageData);
        content.setLayout(contentUiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;
        data = FileUtil.readText("static/dashboard.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}