package com.digiwin.mobile.mobileuibot.dashboard;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.BallRouter;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileClassificatonResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileDatasourceInfoResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.recommend.rule.*;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：工作台页面V2构建策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildDashboardV2Strategy
 * @Author: xujinc
 * @Date: 2024/11/29 10:41
 */
@Slf4j
@Component("uiBotModelBuildDashboardV2Strategy")
public class UiBotModelBuildDashboardV2Strategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private RecommendRuleService recommendRuleService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private BallRouter ballRouter;

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Buildv2Dashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                 StopWatch stopWatch) {
        PageSetting actualPageSetting = new PageSetting();
        actualPageSetting.setSystemDefault(pageSetting.getSystemDefault());
        actualPageSetting.setPageTitle(pageSetting.getPageTitle());

        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList = new ArrayList<>();
        //组装应用作业数据
        List<BaseMobileComponentWrapper<BaseMobileComponent>> baseMobileComponentList = getClassAppComponent(apiRequest);
        if (!CollectionUtils.isEmpty(baseMobileComponentList)) {
            bodyCmptList.addAll(baseMobileComponentList);
        }
        //报表区域
        List<AppModuleItem> reportFormAppModuleItemList = this.getReportForm(apiRequest);
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty(reportFormAppModuleItemList)) {
            hasReportModule = true;

            CustomContent reportFormCustomContent = new CustomContent();
            reportFormCustomContent.setCode(AppModuleCodeEnum.REPORT_FORM.getCode());
            reportFormCustomContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.REPORT_FORM.getName()));
            reportFormCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
            reportFormCustomContent.setRowSize(2);
            reportFormCustomContent.setLimitShowSize(4);

            reportFormCustomContent.setSubTitle(localeService.getLanguageValue(apiRequest.getLocale(), "查看更多") + ">");
            Action subTitleAction = new Action();
            subTitleAction.setJumpPageTitle(reportFormCustomContent.getTitle());
            subTitleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPORT_LIST.toString());
            subTitleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            reportFormCustomContent.setSubTitleAction(subTitleAction);
            reportFormCustomContent.addAllComponentsToGroup(reportFormAppModuleItemList, "DW_" + AppModuleItem.COMPONENT_TYPE);
            bodyCmptList.add(new BaseMobileComponentWrapper<>(reportFormCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        }

        //手动发起项目
        List<AppModuleItem> startProjectAppModuleItemList = this.getStartProjectAppModuleItemList(apiRequest);
        if (!CollectionUtils.isEmpty(startProjectAppModuleItemList)) {
            CustomContent startProjectCustomContent = new CustomContent();
            startProjectCustomContent.setCode(AppModuleCodeEnum.START_PROJECT.getCode());
            startProjectCustomContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.START_PROJECT.getName()));
            startProjectCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
            startProjectCustomContent.setRowSize(2);
            startProjectCustomContent.setLimitShowSize(startProjectAppModuleItemList.size());
            startProjectCustomContent.addAllComponentsToGroup(startProjectAppModuleItemList, "DW_" + AppModuleItem.COMPONENT_TYPE);
            bodyCmptList.add(new BaseMobileComponentWrapper<>(startProjectCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        }

        //数据录入
        CustomContent dataEntryCustomContent = new CustomContent();
        Map<String, Object> sysParamMap = new HashMap<>();
        sysParamMap.put("clientId", apiRequest.getClientId());
        sysParamMap.put("iamUserToken", apiRequest.getIamUserToken());
        sysParamMap.put("tenantId", apiRequest.getTenantId());
        sysParamMap.put("locale", apiRequest.getLocale());
        sysParamMap.put("userId", apiRequest.getUserId());
        sysParamMap.put("code", AppModuleCodeEnum.DATA_ENTRY.getCode());
        dataEntryCustomContent.setSysParam(sysParamMap);
        dataEntryCustomContent.setUrl(AppContext.getBaseUrl() + "/mobile/v2/dashboard/dataEntry/async");
        bodyCmptList.add(new BaseMobileComponentWrapper<>(dataEntryCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));

        //智能入口
        List<AppModuleItem> intelligentEnterAppModuleItemList = getIntelligentEnterAppModuleItemList(apiRequest, hasReportModule);
        if (!CollectionUtils.isEmpty(intelligentEnterAppModuleItemList)) {
            CustomContent intelligentEnterCustomContent = new CustomContent();
            intelligentEnterCustomContent.setCode(AppModuleCodeEnum.INTELLIGENT_ENTER.getCode());
            intelligentEnterCustomContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.INTELLIGENT_ENTER.getName()));
            intelligentEnterCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
            intelligentEnterCustomContent.setRowSize(4);
            intelligentEnterCustomContent.setLimitShowSize(intelligentEnterAppModuleItemList.size());
            intelligentEnterCustomContent.addAllComponentsToGroup(intelligentEnterAppModuleItemList, "DW_" + AppModuleItem.COMPONENT_TYPE);
            bodyCmptList.add(new BaseMobileComponentWrapper<>(intelligentEnterCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        }

        //绿色智机
        // wjw FIXME: 2025/9/3 后端临时修复bug，工作台前端未传递isHavePreset参数时处理
        if (null == apiRequest.getIsHavePreset()) {
            TopicPresetResp topicPresetResp = digiwinSemcProxyService.queryUserAuth(apiRequest.getLocale(), apiRequest.getIamUserToken());
            apiRequest.setIsHavePreset(Optional.ofNullable(topicPresetResp).map(TopicPresetResp::getIsHavePreset).orElse(false));
        }
        if (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset()) {
            CustomContent smartMachineCustomContent = CustomContent.create(apiRequest.getLocale(), apiRequest.getClientId(),
                    apiRequest.getIamUserToken(), "",
                    AppContext.getBaseUrl() + "/mobile/v2/dashboard/smartMachine/async", true);
            bodyCmptList.add(new BaseMobileComponentWrapper<>(smartMachineCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        }

        if (CollectionUtils.isEmpty(bodyCmptList)) {
            WebviewPanel webviewPanel = new WebviewPanel();
            webviewPanel.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), "敬请期待") + "!");
            webviewPanel.setData(new ArrayList<>());
            bodyCmptList.add(new BaseMobileComponentWrapper<>(webviewPanel, "DW_" + WebviewPanel.COMPONENT_TYPE));
        }

        SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
        singleListContainer.addAll(bodyCmptList);
        uiBotModel.getRenderData().addWrapperedComponentToBody(
                new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
        return uiBotModel;
    }

    /**
     * 组装semc的分类和应用作业
     *
     * @param apiRequest
     * @return
     */
    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getClassAppComponent(ApiRequest apiRequest) {

        List<BaseMobileComponentWrapper<BaseMobileComponent>> baseMobileComponentList = new ArrayList<>();
        //请求semc接口获取移动应用作业信息
        ApiRequsetPortal apiRequsetPortal = new ApiRequsetPortal();
        apiRequsetPortal.setIsAll(true);
        apiRequsetPortal.setLocale(apiRequest.getLocale());
        apiRequsetPortal.setIamUserToken(apiRequest.getIamUserToken());
        List<MobileClassificatonResp> classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        //分类为空，不组装组件
        if (CollectionUtils.isEmpty(classificatonRespList)) {
            return baseMobileComponentList;
        }
        try {
            //组装返回组件
            for (MobileClassificatonResp classificatonResp : classificatonRespList) {
                //如果分类下作业为空，则不组装
                if (CollectionUtils.isEmpty(classificatonResp.getMobileCustomAppList())) {
                    continue;
                }
                CustomContent classCustomContent = new CustomContent();
                //分类名称
                classCustomContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), classificatonResp.getClassificationName()));
                //2 代表 上图下文 布局
                classCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
                //每行展示4个
                classCustomContent.setRowSize(4);
                //最多展示几个，如果limitShowSize== contentGroup.length代表全部平铺展示
                Integer limitShowSize = classificatonResp.getMobileCustomAppList().size();
                classCustomContent.setLimitShowSize(limitShowSize);
                //组装分类下应用作业
                List<AppModuleItem> appModuleItemList = new ArrayList<>();
                for (MobileDatasourceInfoResp customApp : classificatonResp.getMobileCustomAppList()) {
                    MobileBallResp mobileBallResp = new MobileBallResp();
                    mobileBallResp.setCustomApplicationId(customApp.getId());
                    mobileBallResp.setCallBackUrl("");
                    mobileBallResp.setBallName("");
                    Action action = ballRouter.getCompoentAction(PortalConstans.CUSTOM_APPLICATION, apiRequest, mobileBallResp);
                    AppModuleItem moduleItem = new AppModuleItem();
                    moduleItem.setAction(action);
                    //应用作业名称
                    moduleItem.setName(customApp.getName());
                    //应用作业跳转地址
                    moduleItem.setImageUrl(customApp.getIcon());
                    appModuleItemList.add(moduleItem);
                }
                classCustomContent.addAllComponentsToGroup(appModuleItemList, "DW_" + AppModuleItem.COMPONENT_TYPE);
                BaseMobileComponentWrapper<BaseMobileComponent> baseMobileComponentWrapper = new BaseMobileComponentWrapper<>(classCustomContent, "DW_" + CustomContent.COMPONENT_TYPE);
                baseMobileComponentList.add(baseMobileComponentWrapper);
            }
        } catch (Exception e) {
            log.error("getClassAppComponent error:{}", e);
            return baseMobileComponentList;
        }
        return baseMobileComponentList;
    }


    private List<AppModuleItem> getReportForm(ApiRequest apiRequest) {
        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty(tmDataList)) {
            return Collections.emptyList();
        }

        List<AppModuleItem> appModuleItemList = new ArrayList<>();
        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            if (CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                continue;
            }
            for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                if (dataReport.isAllow()) {
                    //M2需求-过滤ABI报表
                    //if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
                    //    BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.createABIReportButton(
                    //            dataReport.getName(), dataReport, dataReport.getCode());
                    //    AppModuleItem appModuleItem = JsonUtil.objectToJavaObject(bottomButtonDigiwinAthena, AppModuleItem.class);
                    //    appModuleItem.setBgColor("#EEF1FF");
                    //    appModuleItem.setAccessRecord(null);
                    //    appModuleItemList.add(appModuleItem);
                    //} else
                    if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) {
                        BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.createTBBReportButton(
                                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                                Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()),
                                dataReport.getName());
                        AppModuleItem appModuleItem = JsonUtil.objectToJavaObject(bottomButtonDigiwinAthena, AppModuleItem.class);
                        appModuleItem.setBgColor("#EEF1FF");
                        appModuleItem.setAccessRecord(null);
                        appModuleItemList.add(appModuleItem);
                    }
                }
            }
        }
        return appModuleItemList;
    }

    private List<AppModuleItem> getStartProjectAppModuleItemList(ApiRequest apiRequest) {
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String locale = apiRequest.getLocale();

        List<LaunchableProject> accessibleLaunchableProjectList =
                this.projectService.getLaunchableProjectList(iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty(accessibleLaunchableProjectList)) {
            return Collections.emptyList();
        }
        return accessibleLaunchableProjectList.stream()
                .map(project -> {
                    AppModuleItem appModuleItem = new AppModuleItem();
                    appModuleItem.setId(project.getCode());
                    //处理智慧检料名字
                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
                        appModuleItem.setName(project.getName().substring(0, 4));
                    } else {
                        appModuleItem.setName(project.getName());
                    }
                    Action<Map<String, Object>> action = new Action<>();
                    // 发起项目设计器跳转需要的信息
                    if (BooleanUtils.isTrue(project.getIsDesigner())) {
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                        action.setJumpPageTitle(project.getName());
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("project_introduce", project.getDesc());
                        rawData.put("project_name", project.getName());
                        rawData.put("dataId", project.getCreateSuffix());
                        action.setRawData(rawData);
                    } else {
                        if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                            Action rawDataAction = new Action();
                            rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            rawDataAction.setJumpPageTitle(project.getName());
                            rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            rawDataAction.setDataId(project.getCreateSuffix());
                            Map<String, Object> rawData = new HashMap<>(2);
                            rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                            rawData.put("action", rawDataAction);
                            action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                            action.setRawData(rawData);
                        } else {
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            action.setJumpPageTitle(project.getName());
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            action.setDataId(project.getCreateSuffix());
                        }
                    }

                    appModuleItem.setAction(action);
//                    //处理智慧检料图标
//                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
//                        appModuleItem.setImage("IMAGE_" + ProjectConstant.LAUNCH_EXCLUDED_PROJECT_TM_ACTIVITY_ID);
//                    } else {
//                        appModuleItem.setImage("IMAGE_" + project.getCreateSuffix());
//                    }
                    appModuleItem.setBgColor("#EEF1FF");
                    return appModuleItem;
                }).collect(Collectors.toList());
    }

    public List<AppModuleItem> getIntelligentEnterAppModuleItemList(ApiRequest apiRequest, boolean hasReportModule) {
        List<AppModuleItem> intelligentEnterAppModuleItemList = new ArrayList<>();
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String locale = apiRequest.getLocale();

        // 获取所有可用应用清单
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List<String> goodsCodes =
                this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(
                        analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }
        List<RecommendRule> recommendRules = this.recommendRuleService
                .findRuleByCategory(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        // 购买规则
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream()
                .filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()))
                .sorted(Comparator.comparingInt(RecommendRule::getOrder))
                .collect(Collectors.toList());
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(purchasedGoodsRecommendRules)){
            return null;
        }
        // 配置的规则和实际查询出来的购买情况做比对，只有实际购买过才能在App看到
        //List<AppModuleItem> appModuleItemList = new ArrayList<>();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = JsonUtil.objectToJavaObject(pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }

            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream()
                    .anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode)
                            // 配置中用Athena表示所有用户均可用的功能
                            || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    // 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    //数据录入从智能入口拿出来作为一个单独模块
                    if ("BASIC_DATA_ENTRANCE".equals(moduleId)) {
                        return;
                    }

                    boolean moduleEnableInFact = true;
                    if (verify) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            // 人员状态入口需要根据作业id判断是否有展示权限
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(
                                    analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId,
                                    iamUserToken);
                        }
                    }

                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId())
                                    .replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid()))
                                    .replace("{tenantName}", analyzedToken.getTenantName())
                                    .replace("{userId}", analyzedToken.getId())
                                    .replace("{userName}", analyzedToken.getName())
                                    .replace("{token}", iamUserToken)
                                    .replace("{locale}", locale);
                        }
                        if (StringUtils.hasLength(requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        AppModuleItem appModuleItem = AppModuleItem
                                .create(mobileConfig.getName(), mobileConfig.getIconData(),
                                        mobileConfig.getIconColor(),
                                        mobileConfig.getAction().getJumpPageId(),
                                        mobileConfig.getAction().getJumpPageTitle(),
                                        mobileConfig.getAction().getType(),
                                        requestUrl,
                                        mobileConfig.getImage(), mobileConfig.getImageUrl());
                        appModuleItem.getAction().setDataId(mobileConfig.getAction().getDataId());
                        appModuleItem.setId(pgrrGoodsCode + "_" + moduleId);
                        appModuleItem.setBgColor("#EEF1FF");
                        if (validAndHandleAppModuleItem(apiRequest, appModuleItem, hasReportModule)) {
                            intelligentEnterAppModuleItemList.add(appModuleItem);
                        }
                    }
                });
            }
        });
        return intelligentEnterAppModuleItemList;
    }

    private boolean validAndHandleAppModuleItem(ApiRequest apiRequest, AppModuleItem appModuleItem, boolean hasReportModule) {
        Boolean isZtbDriver = Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false);
        if ("srm-loading_srm-loading".equalsIgnoreCase(appModuleItem.getId())) {
            if (!isZtbDriver && (StrUtil.equals(appModuleItem.getAction().getDataId(), "shipper") || StrUtil.equals(appModuleItem.getAction().getDataId(), "receiver"))) {
                appModuleItem.setName(localeService.getLanguageValue(apiRequest.getLocale(), appModuleItem.getName()));
                Map<String, Object> params = new HashMap<>(1);
                params.put("module_type", "2");
                String url = digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId()
                        + "&transportType=" + (StrUtil.equals(appModuleItem.getAction().getDataId(), "shipper") ? "1" : "2");
                appModuleItem.getAction().setRequestUrl(url);
                return true;
            }
            if (isZtbDriver && StrUtil.equals(appModuleItem.getAction().getDataId(), "driver")) {
                appModuleItem.setName(localeService.getLanguageValue(apiRequest.getLocale(), appModuleItem.getName()));
                Map<String, Object> params = new HashMap<>(1);
                params.put("module_type", "2");
                String url = digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId();
                appModuleItem.getAction().setRequestUrl(url);
                return true;
            }
            return false;
        } else if ("TipBiuBI_datasource".equalsIgnoreCase(appModuleItem.getId())) {
            // TBB报表
            if (StringUtils.hasLength(Optional.ofNullable(appModuleItem.getAction()).map(Action::getRequestUrl).orElse(null))) {
                String requestUrl = appModuleItem.getAction().getRequestUrl()
                        .replaceAll("\\$\\{locale}", apiRequest.getLocale())
                        .replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken());
                appModuleItem.getAction().setRequestUrl(requestUrl);
            }
        } else if ("Athena_GLOBAL_INFORMATION".equals(appModuleItem.getId())) {
            // 存在报表权限与数据，显示全局资讯入口
            return hasReportModule;
        }
        return true;
    }


    /**
     * 判断作业id是否匹配
     *
     * @param userId
     * @param pgrrGoodsCode
     * @param iamUserToken
     * @param module
     * @return
     */
    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;

        Optional optional = Optional.ofNullable(userPermission)
                .map(DigiwinIamUserAuthInfo::getResult)
                .map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent()) {
            if (userPermission != null && userPermission.getResult() != null) {
                isMatchWorkId = userPermission.getResult().getPermissions().
                        stream().anyMatch(e -> e.getId().equals(module.getWorkId())
                                && "allow".equalsIgnoreCase(e.getEffect()));
            }

        }
        return isMatchWorkId;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}