package com.digiwin.mobile.mobileuibot.dashboard.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleItemGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleQueryListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleUpdateListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.machinePreset.service.MachinePresetService;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/***
 * 工作台接口-V2
 */
@RestController
@RequestMapping("/mobile/v2/dashboard")
@Slf4j
public class DashBoardController {

    @Autowired
    MachinePresetService machinePresetService;

    @Autowired
    DigiwinSemcProxyService semcProxyService;

    @Autowired
    private DashBoardService dashBoardService;

    @Autowired
    private LocaleService localeService;


    /***
     * 数据录入
     */
    @PostMapping("/dataEntry/async")
    public ApiResponse<UiBotModel> dataEntryAsync(@RequestBody CustomContentRequest customContentRequest) {
        UiBotModel uiBotModel = dashBoardService.dataEntryAsync(customContentRequest);
        return ApiResponse.buildOK().setData(uiBotModel);
    }


    /***
     * 绿色智机
     */
    @PostMapping("/smartMachine/async")
    public ApiResponse<UiBotModel> smartMachineAsync(@RequestBody CustomContentRequest customContentRequest) {
        UiBotModel uiBotModel = dashBoardService.smartMachineAsync(customContentRequest);
        return ApiResponse.buildOK().setData(uiBotModel);
    }

    /***
     * 管理页和查看更多数据
     */
    @PostMapping("/module/list/get")
    public ApiResponse<List<ModuleItemGroupByApp>> getModuleList(@RequestBody DashBoardModuleQueryListRequest dashBoardModuleQueryListRequest) {
        List<ModuleItemGroupByApp> moduleItemGroupByAppList = dashBoardService.getModuleList(dashBoardModuleQueryListRequest);
        return ApiResponse.buildOK().setData(moduleItemGroupByAppList);
    }

    /***
     * 排序，置顶，取消置顶
     */
    @PostMapping("/module/list/update")
    public ApiResponse getModuleList(@RequestBody DashBoardModuleUpdateListRequest dshBoardModuleUpdateListRequest) {
        boolean isSuccess = dashBoardService.updateModuleInfo(dshBoardModuleUpdateListRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "保存" + (BooleanUtils.isTrue(isSuccess) ? "成功" : "失败");
        action.setToastMsg(localeService.getLanguageValue(dshBoardModuleUpdateListRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData(action);
    }
}