package com.digiwin.mobile.mobileuibot.dashboard.service;

import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleItemGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleQueryListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleUpdateListRequest;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.util.List;

/**
 * <p>功能描述：工作台V2业务实现类</p>
 *
 * @FileName: DashBoardService
 * @Author: xujinc
 * @Date: 2024/12/11 14:37
 */
public interface DashBoardService {

    /**
     * 数据录入异步获取
     *
     * @param customContentRequest
     * @return
     */
    UiBotModel dataEntryAsync(CustomContentRequest customContentRequest);

    /**
     * 绿色智机异步获取
     *
     * @param customContentRequest
     * @return
     */
    UiBotModel smartMachineAsync(CustomContentRequest customContentRequest);

    /**
     * 工作台模块信息查询-管理页面
     *
     * @param dashBoardModuleQueryListRequest
     * @return
     */
    List<ModuleItemGroupByApp> getModuleList(DashBoardModuleQueryListRequest dashBoardModuleQueryListRequest);

    /**
     * 工作台模块信息更新-管理页面
     *
     * @param dshBoardModuleUpdateListRequest
     * @return
     */
    boolean updateModuleInfo(DashBoardModuleUpdateListRequest dshBoardModuleUpdateListRequest);

    /**
     * 工作台模块信息-数据录入
     *
     * @param clientId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<AppModuleItem> getDataEntryModuleList(String clientId, String iamUserToken, String tenantId, String locale);

}
