package com.digiwin.mobile.mobileuibot.dashboard.service.impl;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleCodeGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleItemGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleQueryListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleUpdateListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.UserDashBoardSetting;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.service.UserDashBoardSettingService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetJobResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：工作台V2业务实现类</p>
 *
 * @FileName: DashBoardServiceImpl
 * @Author: xujinc
 * @Date: 2024/12/11 14:37
 */
@Service
@Slf4j
public class DashBoardServiceImpl implements DashBoardService {

    @Autowired
    private UserDashBoardSettingService userDashBoardSettingService;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel dataEntryAsync(CustomContentRequest customContentRequest) {
        Map<String, Object> sysParam = customContentRequest.getSysParam();
        String locale = MapUtils.getString(sysParam, "locale");
        String iamUserToken = MapUtils.getString(sysParam, "iamUserToken");
        String clientId = MapUtils.getString(sysParam, "clientId");
        String tenantId = MapUtils.getString(sysParam, "tenantId");
        String userId = MapUtils.getString(sysParam, "userId");
        String code = MapUtils.getString(sysParam, "code");

        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }

        List<AppModuleItem> appModuleItemList = this.getDataEntryModuleList(clientId, iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty(appModuleItemList)) {
            return uiBotModel;
        }

        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(userId);
        userDashBoardSetting.setTenantId(tenantId);
        userDashBoardSetting.setCode(code);
        UserDashBoardSetting userDashBoardSettingQuery = userDashBoardSettingService.getUserDashBoardSetting(userDashBoardSetting);
        if (Objects.nonNull(userDashBoardSettingQuery)) {
            List<ModuleCodeGroupByApp> moduleSettingCodeGroupByAppList = JsonUtil.jsonStringToObject(userDashBoardSettingQuery.getData(), new TypeReference<List<ModuleCodeGroupByApp>>() {
            });
            if (!CollectionUtils.isEmpty(moduleSettingCodeGroupByAppList)) {
                Map<String, ModuleCodeGroupByApp.AppGroupItem> appGroupItemMapById = moduleSettingCodeGroupByAppList.stream().flatMap(e -> e.getItemList().stream())
                        .collect(Collectors.toMap(ModuleCodeGroupByApp.AppGroupItem::getId, e -> e, (a, b) -> a));

                //更新置顶标识
                appModuleItemList.forEach(item -> item.setIsTop(Optional.ofNullable(appGroupItemMapById.get(item.getId()))
                        .map(ModuleCodeGroupByApp.AppGroupItem::getIsTop)
                        .orElse(false)));

                //将置顶的数据放在前面
                appModuleItemList = appModuleItemList.stream().sorted(Comparator.comparing(item -> item.getIsTop() ? 0 : 1))
                        .collect(Collectors.toList());
            }
        }

        String subTitle;
        Action subTitleAction = new Action();
        if (appModuleItemList.size() > 4) {
            subTitle = localeService.getLanguageValue(locale, "查看更多>");
            subTitleAction.setType(ActionTypeEnum.JUMP_SEE_MORE.getValue());
        } else {
            subTitle = localeService.getLanguageValue(locale, "管理");
            subTitleAction.setType(ActionTypeEnum.JUMP_MANAGE.getValue());
        }
        CustomContent dataEntryCustomContent = new CustomContent();
        dataEntryCustomContent.setCode(AppModuleCodeEnum.DATA_ENTRY.getCode());
        dataEntryCustomContent.setTitle(localeService.getLanguageValue(locale, AppModuleCodeEnum.DATA_ENTRY.getName()));
        dataEntryCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
        dataEntryCustomContent.setRowSize(2);
        dataEntryCustomContent.setLimitShowSize(4);
        dataEntryCustomContent.setSubTitle(subTitle);
        dataEntryCustomContent.setSubTitleAction(subTitleAction);
        dataEntryCustomContent.addAllComponentsToGroup(appModuleItemList, "DW_" + AppModuleItem.COMPONENT_TYPE);
        uiBotModel.getRenderData().addWrapperedComponentToBody(
                new BaseMobileComponentWrapper<>(dataEntryCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        return uiBotModel;
    }

    @Override
    public UiBotModel smartMachineAsync(CustomContentRequest customContentRequest) {
        Map<String, Object> sysParam = customContentRequest.getSysParam();
        String locale = (String) sysParam.get("locale");
        String iamUserToken = (String) sysParam.get("iamUserToken");

        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }

        //查询用户模组作业
        List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(new ArrayList<>(), locale, iamUserToken);
        if (CollectionUtils.isEmpty(topicPresetRespList)) {
            return uiBotModel;
        }

        List<CustomGroup> customGroupList = buildCustomGroupList(topicPresetRespList, locale);

        CustomContent smartMachineCustomContent = new CustomContent();
        smartMachineCustomContent.setCode(AppModuleCodeEnum.SMART_MACHINE.getCode());
//        smartMachineCustomContent.setTitle(localeService.getLanguageValue(locale, AppModuleCodeEnum.SMART_MACHINE.getName()));
        smartMachineCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
        smartMachineCustomContent.setRowSize(1);
        smartMachineCustomContent.setLimitShowSize(customGroupList.size());
        smartMachineCustomContent.setSubComponentName(CustomGroup.COMPONENT_TYPE);
        smartMachineCustomContent.addAllComponentsToGroup(customGroupList, "DW_" + CustomGroup.COMPONENT_TYPE);
        uiBotModel.getRenderData().addWrapperedComponentToBody(
                new BaseMobileComponentWrapper<>(smartMachineCustomContent, "DW_" + CustomContent.COMPONENT_TYPE));
        return uiBotModel;
    }

    @Override
    public List<ModuleItemGroupByApp> getModuleList(DashBoardModuleQueryListRequest request) {

        List<AppModuleItem> dataEntryModuleList = this.getDataEntryModuleList(request.getClientId(), request.getIamUserToken(), request.getTenantId(), request.getLocale());
        if (CollectionUtils.isEmpty(dataEntryModuleList)) {
            return Collections.emptyList();
        }

        // 获取有权限的作业并按模块分组
        Map<String, List<AppModuleItem>> dataEntryModuleListMapByParentCode = dataEntryModuleList.stream().collect(Collectors.groupingBy(AppModuleItem::getParentCode));

        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(request.getUserId());
        userDashBoardSetting.setTenantId(request.getTenantId());
        userDashBoardSetting.setCode(request.getCode());
        UserDashBoardSetting userDashBoardSettingQuery = userDashBoardSettingService.getUserDashBoardSetting(userDashBoardSetting);

        List<ModuleItemGroupByApp> moduleItemGroupByAppList = new ArrayList<>();
        if (Objects.nonNull(userDashBoardSettingQuery)) {
            List<ModuleCodeGroupByApp> moduleSettingCodeGroupByAppList = JsonUtil.jsonStringToObject(userDashBoardSettingQuery.getData(), new TypeReference<List<ModuleCodeGroupByApp>>() {
            });

            if (!CollectionUtils.isEmpty(moduleSettingCodeGroupByAppList)) {
                //以表中记录的作业顺序为准遍历
                for (ModuleCodeGroupByApp moduleSettingCodeGroupByApp : moduleSettingCodeGroupByAppList) {

                    //判断表中的对应整个模块权限是否存在，不存在则不显示
                    if (dataEntryModuleListMapByParentCode.containsKey(moduleSettingCodeGroupByApp.getAppCode())) {

                        //获取当前模块下有权限的作业
                        List<AppModuleItem> dataEntryModuleListByParentCode = dataEntryModuleListMapByParentCode.get(moduleSettingCodeGroupByApp.getAppCode());
                        Map<String, AppModuleItem> dataEntryModuleListById = dataEntryModuleListByParentCode.stream().collect(Collectors.toMap(AppModuleItem::getId, e -> e, (a, b) -> a));

                        List<ModuleItemGroupByApp.AppGroupItem> newAppGroupItemList = new ArrayList<>();
                        for (ModuleCodeGroupByApp.AppGroupItem moduleSettingAppCodeGroupItem : moduleSettingCodeGroupByApp.getItemList()) {

                            //判断表中当前模块下作业权限是否存在，不存在则不显示
                            if (dataEntryModuleListById.containsKey(moduleSettingAppCodeGroupItem.getId())) {

                                AppModuleItem appModuleItemById = dataEntryModuleListById.get(moduleSettingAppCodeGroupItem.getId());
                                ModuleItemGroupByApp.AppGroupItem newAppGroupItem = JsonUtil.objectToJavaObject(appModuleItemById, ModuleItemGroupByApp.AppGroupItem.class);
                                newAppGroupItem.setIsTop(moduleSettingAppCodeGroupItem.getIsTop());
                                newAppGroupItemList.add(newAppGroupItem);

                                //过滤库里保存的作业，得到新的有权限的作业
                                dataEntryModuleListById.remove(moduleSettingAppCodeGroupItem.getId());
                            }
                        }

                        //如果当前模块下有新的有权限的作业，这时库里没有，需要添加到新的作业列表中
                        if (!CollectionUtils.isEmpty(dataEntryModuleListById)) {
                            dataEntryModuleListById.values().forEach(e -> {
                                ModuleItemGroupByApp.AppGroupItem newAppGroupItem = JsonUtil.objectToJavaObject(e, ModuleItemGroupByApp.AppGroupItem.class);
                                newAppGroupItemList.add(newAppGroupItem);
                            });
                        }

                        ModuleItemGroupByApp moduleItemGroupByApp = new ModuleItemGroupByApp();
                        moduleItemGroupByApp.setAppCode(dataEntryModuleListByParentCode.get(0).getParentCode());
                        moduleItemGroupByApp.setAppName(dataEntryModuleListByParentCode.get(0).getParentName());
                        moduleItemGroupByApp.setItemList(newAppGroupItemList);
                        moduleItemGroupByAppList.add(moduleItemGroupByApp);

                        dataEntryModuleListMapByParentCode.remove(moduleSettingCodeGroupByApp.getAppCode());
                    }
                }
            }
        }

        //如果有新的整个模块，这时库里没有，则添加整个模块（包括模块下的作业）
        if (!CollectionUtils.isEmpty(dataEntryModuleListMapByParentCode)) {
            dataEntryModuleListMapByParentCode.values().forEach(item -> {
                ModuleItemGroupByApp moduleItemGroupByApp = new ModuleItemGroupByApp();
                moduleItemGroupByApp.setAppCode(item.get(0).getParentCode());
                moduleItemGroupByApp.setAppName(item.get(0).getParentName());
                List<ModuleItemGroupByApp.AppGroupItem> newAppGroupItemList = JsonUtil.objectToJavaObject(item, new TypeReference<List<ModuleItemGroupByApp.AppGroupItem>>() {
                });
                moduleItemGroupByApp.setItemList(newAppGroupItemList);
                moduleItemGroupByAppList.add(moduleItemGroupByApp);
            });
        }
        return moduleItemGroupByAppList;
    }

    /**
     * 工作台模块信息更新-管理页面
     *
     * @param dshBoardModuleUpdateListRequest
     * @return
     */
    @Override
    public boolean updateModuleInfo(DashBoardModuleUpdateListRequest dshBoardModuleUpdateListRequest) {
        UserDashBoardSetting userDashBoardSetting = new UserDashBoardSetting();
        userDashBoardSetting.setUserId(dshBoardModuleUpdateListRequest.getUserId());
        userDashBoardSetting.setTenantId(dshBoardModuleUpdateListRequest.getTenantId());
        userDashBoardSetting.setCode(dshBoardModuleUpdateListRequest.getCode());
        if (!CollectionUtils.isEmpty(dshBoardModuleUpdateListRequest.getAppList())) {
            userDashBoardSetting.setData(JsonUtil.javaObjectToJsonString(dshBoardModuleUpdateListRequest.getAppList()));
        }
        return userDashBoardSettingService.insertOrUpdateUserDashBoardSetting(userDashBoardSetting);
    }

    @Override
    public List<AppModuleItem> getDataEntryModuleList(String clientId, String iamUserToken, String tenantId, String locale) {
        List<DigiwinAtmcTmData> basicDataList =
                digiwinAudcProxyService.getBasicDataList(clientId, iamUserToken, tenantId, locale);

        if (CollectionUtils.isEmpty(basicDataList)) {
            return Collections.emptyList();
        }

        String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        // 获取type为数据录入的数据
        List<String> tmActivityIdList = activityFilterService
                .findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), tenantId, tenantVersion)
                .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            return Collections.emptyList();
        }

        List<AppModuleItem> appModuleItemList = new ArrayList<>();
        basicDataList.forEach(tmData -> {
            tmData.getBaseItemDtoList().forEach(itemDto -> {
                if (itemDto.isAllow() && tmActivityIdList.contains(itemDto.getCode())) {
                    AppModuleItem appModuleItem = new AppModuleItem();
                    appModuleItem.setName(itemDto.getName());
                    appModuleItem.setId(itemDto.getCode());
                    appModuleItem.setParentCode(tmData.getAppCode());
                    appModuleItem.setParentName(tmData.getAppName());
                    appModuleItem.setBgColor("#FFF3E4");

                    Action<?> action = new Action<>();
                    appModuleItem.setAction(action);

                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    if ("SIGN-DOCUMENT".equals(itemDto.getCategory())) {
                        // 单档多栏(模型驱动)
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                    } else if (Lists.newArrayList("DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI").contains(itemDto.getCategory())) {
                        // 单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动)
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                    } else {
                        // 不存在，返回
                        return;
                    }
                    action.setJumpPageTitle(itemDto.getName());
                    action.setDataId(itemDto.getCode());
                    appModuleItemList.add(appModuleItem);
                }
            });
        });
        return appModuleItemList;
    }

    public List<CustomGroup> buildCustomGroupList(List<TopicPresetResp> topicPresetRespList, String locale) {
        return topicPresetRespList.stream().map(topicPresetResp -> {
            CustomGroup customGroup = new CustomGroup();
            customGroup.setName(topicPresetResp.getModuleName());
            customGroup.setStyleType(CustomGroupStyleTypeEnum.TITLE_BLACK.getValue());

            AppEntrance appEntrance = new AppEntrance();
            List<AppFunctionTouchable> appList = addJobTouchable(topicPresetResp.getTopicpList(), locale);
            appEntrance.setAppList(appList);

            customGroup.addComponentToGroup(appEntrance, "DW_" + AppEntrance.COMPONENT_TYPE);
            return customGroup;
        }).collect(Collectors.toList());
    }

    /**
     * 组装作业appList
     *
     * @param topicpList 返回的权限内作业信息
     * @return
     */
    public List<AppFunctionTouchable> addJobTouchable(List<TopicPresetJobResp> topicpList, String locale) {
        List<AppFunctionTouchable> appList = new ArrayList<>();
        //组装作业信息
        for (TopicPresetJobResp topicp : topicpList) {
            AppFunctionTouchable touchable = new AppFunctionTouchable();
            //作业图片地址
            touchable.setIconUrl(topicp.getTopicPresetIcon());
            touchable.setImageUrl(topicp.getTopicPresetIcon());
            //作业名称
            touchable.setName(topicp.getTopicPresetName());
            //作业caseId，用于金刚区记录
            touchable.setId(topicp.getCaseId());
            Action action = new Action();
            action.setOpenWebPageTitle(topicp.getTopicPresetName());
            //跳转url
            action.setRequestUrl(topicp.getTopicPresetUrl());
            //跳转类型-webview
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            //如果没有设置公司别和厂别，给出提示
            if (!topicp.getIsSetCompany()) {
                action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                action.setToastMsg(localeService.getLanguageValue(locale, "请先设置公司别和厂别"));
            }
            touchable.setAction(action);
            appList.add(touchable);
        }
        return appList;
    }

    /**
     * 生成模组的Layout
     *
     * @param topicPresetRespList
     * @return
     */
    public Map<String, TopicPresetResp> addAppUiBot(List<TopicPresetResp> topicPresetRespList, List<UiBotLayout> layoutList) {
        Map<String, TopicPresetResp> topicPresetRespMap = new HashMap<>();
        for (TopicPresetResp topicPreset : topicPresetRespList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType(CustomGroup.COMPONENT_TYPE);
            layoutList.add(layout);
            topicPresetRespMap.put(schema, topicPreset);

        }
        return topicPresetRespMap;
    }

}
