package com.digiwin.mobile.mobileuibot.dataentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：基础资料录入入口清单页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildBasicDataEntranceStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/11/15 15:53
 */
@Component
public class UiBotModelBuildBasicDataEntranceStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }

        List<DigiwinAtmcTmData> basicDataList =
                digiwinAudcProxyService.getBasicDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale());

        if (CollectionUtils.isEmpty(basicDataList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        // 获取type为数据录入的数据
        List<String> tmActivityIdList = activityFilterService
                .findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), apiRequest.getTenantId(), tenantVersion)
                .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList = new ArrayList<>();
        basicDataList.forEach(tmData -> {
            Retractable retractable = new Retractable();
            retractable.setTitle(tmData.getAppName());
            retractable.setIsExpand(true);

            Apposition apposition = new Apposition();
            retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper<>(apposition, "DW_" + Apposition.COMPONENT_TYPE)));

            apposition.setColumns(2);
            List<AppositionData> appositionDataList = new ArrayList<>();
            apposition.setDatas(appositionDataList);

            tmData.getBaseItemDtoList().forEach(itemDto -> {
                if (itemDto.isAllow() && tmActivityIdList.contains(itemDto.getCode())) {
                    Button<?> button = new Button<>();
                    button.setName(itemDto.getName());

                    Action<?> action = new Action<>();
                    button.setAction(action);

                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    if ("SIGN-DOCUMENT".equals(itemDto.getCategory())) {
                        // 单档多栏(模型驱动)
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                    } else if (Lists.newArrayList("DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI").contains(itemDto.getCategory())) {
                        // 单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动)
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                    } else {
                        // 不存在，返回
                        return;
                    }

                    action.setJumpPageTitle(itemDto.getName());
                    action.setDataId(itemDto.getCode());

                    AppositionData appositionData = new AppositionData();
                    appositionData.setComponentType("DW_" + Button.COMPONENT_TYPE);
                    appositionData.setData(button);
                    appositionDataList.add(appositionData);
                }
            });
            if (!CollectionUtils.isEmpty(appositionDataList)) {
                bodyCmptList.add(new BaseMobileComponentWrapper<>(retractable, "DW_" + Retractable.COMPONENT_TYPE));
            }
        });
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
        singleListContainer.addAll(bodyCmptList);
        uiBotModel.getRenderData().addWrapperedComponentToBody(
                new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
