package com.digiwin.mobile.mobileuibot.dataentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.BaseDataPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * <p>功能描述：基础资料录入-基础页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildBasicDataEntryBasicPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/11/15 16:31
 */
@Component
public class UiBotModelBuildBasicDataEntryBasicPageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private BaseDataPageService baseDataPageService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = this.buildBasicPage(apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private UiBotModel buildBasicPage(ApiRequest apiRequest) {
        // 置空，因数据录入--基础页面使用不到此数据
        apiRequest.setSubmitParam(null);
        apiRequest.setSubmitParams(null);
        apiRequest.setCurrentSubmitParam(null);

        String dataId = apiRequest.getDataId();
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), apiRequest.getDataId());
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_BASIC_DATA, null, dataId, PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));

        return baseDataPageService.createBasicDataTaskTemplateForm(executeContext, apiRequest);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}