package com.digiwin.mobile.mobileuibot.dataentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.DWCallWorkEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.BaseDataPageService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：基础资料录入-编辑界面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildBasicDataEntryEditPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/11/15 16:31
 */
@Component
public class UiBotModelBuildBasicDataEntryEditPageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private BaseDataPageService baseDataPageService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = this.buildEditPage(apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private UiBotModel buildEditPage(ApiRequest apiRequest) {
        // 业务类型 为 'local-delete'   |   'local-add'  |  'local-save' ，本地保存时，刷新此页面时才会使用到
        if (!Lists.newArrayList(BusinessTypeEnum.LOCAL_ADD.getValue(),
                        BusinessTypeEnum.LOCAL_SAVE.getValue(),
                        BusinessTypeEnum.LOCAL_DELETE.getValue())
                .contains(apiRequest.getRawData().getBusinessType())) {
            // 置空，因数据录入--编辑页面非本地保存时，此页面使用不到此数据
            apiRequest.setSubmitParam(null);
            apiRequest.setSubmitParams(null);
            apiRequest.setCurrentSubmitParam(null);
        }

        PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("executeContext"), PcUiBotExecuteContext.class);
        if (executeContext == null) {
            return UiBotModel.emptyUiBotModel();
        }
        if (StringUtils.hasText(executeContext.getProxyToken())) {
            AppRequestContext.getContextEntity().setProxyToken(executeContext.getProxyToken());
        }
        if (DWCallWorkEnum.ADD.getValue().equals(apiRequest.getRawData().getDesignParameter().getDWCallWork())) {
            // 区分新增还是保存按钮
            executeContext.setEditType("add");
            if (apiRequest.getRawData().containsKey("data")) {
                // 数据录入新增下重置data数据
                apiRequest.getRawData().put("data", new HashMap<>());
            }
        }

        String tmActivityId = executeContext.getTmActivityId();
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_EDIT_PAGE, null, tmActivityId, PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);

        PcUiBotDoubleDocumentPageDefine pageDefine = new PcUiBotDoubleDocumentPageDefine();
        pageDefine.setParameter((Map<String, Object>) apiRequest.getRawData().get("data"));
        return baseDataPageService.creatDoubleEditPage(executeContext, pageDefine, apiRequest);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
