package com.digiwin.mobile.mobileuibot.dataentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.WorkbenchPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * <p>功能描述：工作台页面数据模型构建策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildWorkbenchPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/8/26 15:31
 */
@Component
public class UiBotModelBuildWorkbenchPageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private WorkbenchPageService workbenchPageService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String dataId = apiRequest.getDataId();
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), dataId);
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_WORKBENCH, null, dataId, PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel = workbenchPageService.createPage(executeContext, apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}