package com.digiwin.mobile.mobileuibot.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：鼎捷雅典娜设计器服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DesignerService
 * @Author: zaregoto
 * @Date: 2023/2/16 10:36
 */
public interface DesignerService {

    /**
     * 任务详情与UiBot设计器集成
     *
     * @param apiRequest
     * @param unprocessedUiBotModel
     * @param systemDefault         true表示是平台页面(受设计器配置影响)，false表示是给应用定制开发的页面（不受设计器配置影响）
     * @return
     */
    UiBotModel integrateTaskDetailWithUiBotDesigner(
            ApiRequest apiRequest,
            UiBotModel unprocessedUiBotModel);

    /**
     * 获取任务详情的UiBot设计器配置 并 组装 apiRequest中的PatternTaskInfo
     *
     * @param apiRequest
     * @param tmTaskId
     * @param tmActivityId
     * @param systemDefault true表示是平台页面(受设计器配置影响)，false表示是给应用定制开发的页面（不受设计器配置影响）
     * @return
     */
    UiBotDesignerConfig initPatternTaskInfoWithUiBotDesigner(
            ApiRequest apiRequest, String tmTaskId, String tmActivityId, Boolean systemDefault, String appCode);

//    /**
//     * 获取任务详情的UiBot设计器配置。通过分别调用鼎捷雅典娜知识图谱服务获得个别配置对象后，融合成一个对象
//     *
//     * @param locale
//     * @param iamUserToken
//     * @param tenantId
//     * @param tmTaskId
//     * @param tmActivityId
//     * @return
//     */
//    UiBotDesignerConfig getTaskDetailUiBotDesignerConfig(String locale, String iamUserToken, String tenantId,
//                                                         String tmTaskId, String tmActivityId);

//    /**
//     * 获取项目详情的UiBot设计器配置。通过分别调用鼎捷雅典娜知识图谱服务获得个别配置对象后，融合成一个对象
//     *
//     * @param locale
//     * @param iamUserToken
//     * @param tenantId
//     * @param tmTaskId
//     * @param tmActivityId
//     * @return
//     */
//    UiBotDesignerConfig getProjectDetailUiBotDesignerConfig(String locale, String iamUserToken, String tenantId,
//                                                            String tmTaskId, String tmActivityId);
}
