package com.digiwin.mobile.mobileuibot.designer.uibot;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：UiBot设计器中的元数据元素的信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerActionMetadataElement
 * @Author: zaregoto
 * @Date: 2023/4/4 15:08
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class UiBotDesignerActionMetadataElement implements Serializable {
    private static final long serialVersionUID = 7400737077080202633L;

    /**
     * 数据名称
     * eg. user_data
     */
    private String dataName;

    /**
     * 数据类型
     * eg. object
     */
    private String dataType;

    /**
     * 当前元素是否必要
     * eg. "true"
     */
    private String required;

    /**
     * 当前元素是否为数据库主键
     * eg. "true"
     */
    private String isDatakey;

    /**
     * 当前字段是否是数组类型
     */
    private Boolean isArray;

    /**
     * 当前字段是否是业务主键
     */
    private Boolean isBusinesskey;

    /**
     * 当前字段描述信息
     */
    private String description;

    /**
     * 当前字段备注信息
     */
    private String remark;

    /**
     * 下层字段
     */
    private List<UiBotDesignerActionMetadataElement> field;

    /**
     * 当前字段精度
     */
    private Object precision;

    /**
     * 当前字段的枚举key
     */
    private Object enumKey;

    /**
     * 当月字段是否用于排序
     */
    private Boolean canSort;
}