package com.digiwin.mobile.mobileuibot.designer.uibot;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：UiBot设计器中的数据源配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerDataSource
 * @Author: zaregoto
 * @Date: 2023/2/16 09:26
 */
@Data
@NoArgsConstructor
public class UiBotDesignerDataSource implements Serializable {
    private static final long serialVersionUID = 8507969544514941765L;

    /**
     * 数据源在配置中使用的id
     */
    private String dataSourceKeyInDesigner;
    private List<String> dataKeys;
    private List<DataProcessor> dataProcessors;
    private String masterData;
    private List<ActionParam> actionParams;
    /**
     * 行动ID，在serviceName基础上增加了"esp_"前缀。
     * 如：serviceName="pdemo.user.get",则actionId="esp_pdemo.user.get"
     */
    private String actionId;
    /**
     * 数据源类型。比如：ESP
     */
    private String type;
    /**
     * 数据源名称
     */
    private String title;
    /**
     * ESP中的服务名称。如pdemo.user.get
     */
    private String serviceName;
    /**
     * ESP中的服务关联的产品名称
     */
    private String productName;

    @Data
    public static class DataProcessor implements Serializable {
        private static final long serialVersionUID = 2481982266413611090L;
        private String type;
        private String serviceName;
    }

    @Data
    public static class ActionParam implements Serializable {
        private static final long serialVersionUID = -1571687652410147252L;

        private String name;
        private String type;
        private String value;
    }
}