package com.digiwin.mobile.mobileuibot.designer.uibot.enums;

import lombok.Getter;

/**
 * <p>功能描述：作业来源分类枚举类(对应不同的处理策略)</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SourceCategoryEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/2/13 9:57
 */
@Getter
public enum SourceCategoryEnum {
    /**
     * 移动工作台
     */
    WORKBENCH,
    /**
     * 任务卡 -- 执行者
     */
    TASK,
    /**
     * 项目卡 -- 当责者
     */
    PROJECT,
    /**
     * 发起项目
     */
    START_PROJECT,
    /*
     * 数据录入--数据驱动1.0与数据驱动2.0
     */
    DATA_ENTRY,
    /**
     * 数据录入--数据驱动2.0 -- 生成的任务卡策略
     */
    DATA_ENTRY_MODEL_DRIVEN,
    /**
     * 数据录入--数据驱动1.0 -- 报工查询 --- 定制
     */
    WORK_REPORT_INFO,
    /**
     * 数据录入--数据驱动1.0 -- APC-机位生产进度 --- 定制
     */
    APC_STAND_PRODUCTION_PROGRESS,
    ;
}
