package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageAction
 * @Author: zaregoto
 * @Date: 2023/2/19 23:13
 */
@Data
@NoArgsConstructor
public class PageAction extends PageActionBase {
    private static final long serialVersionUID = 4622223173291988122L;
    /**
     * 前端定义的UI 类型使用到
     */
    private List<Object> backFills;

    /**
     * 是否通知BPM，只有submitAction才会用到此值
     */
    @Deprecated
    private Boolean dispatchBPM;

    /**
     * 是否通知引擎，任务已经处理完成，只有submitAction才会用到此值
     */
    private boolean dispatch;

    /**
     * 停止bpm流程
     */
    private boolean terminateProcess;

    /**
     * 附加ACTION  当本ACITON 执行完成后去执行另个的API
     */
    private List<PageAction> attachActions;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String, String>> addShowFileds;

    /**
     * 检查完成的action,只有submitAction才会用到此值
     */
    private PageQueryAction checkCompleteAction;

    /**
     * 在任务结束之后才执行
     */
    private Boolean executeAfterCheckCompleted;

    /**
     * submitAction显示的标题
     * 例如：已提交，已审核等
     */
    private String returnText;

    /**
     * 提交的数据源是什么
     * "isBatch": true,
     * "schema": "purchase"
     */
    private PageSubmitType submitType;

    /**
     * 执行按扭时前端 执行的脚本 --- 迭代8 迁移到DataProcess 处理
     */
    private String actionScript;

    /**
     * 是否是默认提交按钮
     */
    private boolean defaultAction;

//    /**
//     * 是否全部提交（check 数据过滤）
//     */
//    private Boolean submitAll;

    /**
     * 提交后数据的状态
     */
    private String targetDataState;

    /**
     * 确认提示框
     */
    private JSONObject confirm;

    /**
     * 组合Action
     */
    private List<PageAction> combineActions;

    /**
     * 配置初始化时，按钮是否可用，
     * ignoreRule：  true 和不配都是不关联
     */
    private Boolean ignoreRule;

    /**
     * 用于用户行为轨迹上报的，轨迹代号
     */
    private String trackCode;

    public void setTrackCode(String trackCode) {
        this.trackCode = trackCode;
    }

    public String getTrackCode() {
        return StringUtils.hasLength(this.trackCode) ? this.trackCode : "SUBMIT";
    }
}
