package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotActionBase
 * @Author: zaregoto
 * @Date: 2023/2/19 23:13
 */
@Data
@NoArgsConstructor
public class PageActionBase implements Serializable {
    private static final long serialVersionUID = -330919426600309762L;
    /**
     * 序号
     */
    private int sequence;

    /**
     * id,唯一值
     */
    private String id;

    /**
     * 名称
     */
    private String name;

    /**
     * 数据源返回的结果集中数据主键
     */
    private List<String> dataKeys;

    /**
     * 显示名称
     */
    private String title;

    /**
     * 服务类型
     * 1.ESP
     */
    private String type;

    /**
     * 数据源ID
     */
    private String actionId;

    /**
     * 按钮类型标示
     */
    private String actionType;

    /**
     * 服务名称
     */
    private String serviceName;

    /**
     * 服务执行URL
     */
    private String url;

    /**
     * 是否代理
     */
    private Boolean needProxyToken;

    /**
     * ESP 使用的产品名称
     */
    private String productName;

    /**
     * API 入参 参数转换设定
     */
    private List<PageActionParameterMapping> actionParams;

    /**
     * API 透传的CONSTANT类型入参，不需要转换
     */
    private Map<String, Object> paras;

    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;

    /**
     * 开窗or提交时追加营运单元信息
     */
    private List<Map> appendRowBusinessUnitSelect;

    /**
     * 是否是客制 ture：是客制；false：非客制（默认不填为非客制）
     */
    private Boolean isCustomize;

    private String schema;

    /**
     * 配置数据源查询入参
     */
    private List<PageActionSearchInfoMapping> searchInfos;
}
