package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDataFilter
 * @Author: zaregoto
 * @Date: 2023/2/19 23:12
 */
@Data
@NoArgsConstructor
public class PageDataFilter implements Serializable {
    private static final long serialVersionUID = -1767677241069003038L;
    /**
     * Filter 编码
     */
    private String code;
    /**
     * 默认优先使用
     */
    private Boolean defaultFilter;

    /**
     * 显示名称
     */
    private String title;

    /**
     * 查询任务的类型
     */
    private String queryTaskType;

    /**
     * 过滤器类型
     */
    private String type;

    /**
     * 为true时，表示使用API进行过滤，服务端过滤，使用conditions，
     * 为false时，表示客户端过滤，使用scriptCondition
     */
    private boolean apiFilter;

    /**
     * 过滤器描述（需要外显）
     */
    private String description;

    /**
     * 作用范围（项目,任务 --卡片，详情）
     */
    private String applyTo;

    /**
     * 作用于数据源的名称
     */
    private List<String> dataSourceNames;

    private List<PageApiFilterCondition> apiCondition;

    /**
     * 显示前limit条数据
     */
    private Integer limit;

    /**
     * 显示获总条数类型
     */
    private String rowSizeType;
}
