package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDataState
 * @Author: zaregoto
 * @Date: 2023/2/19 23:12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PageDataState implements Serializable {
    private static final long serialVersionUID = 5909937240165593776L;

    /**
     * 开窗操作类型
     */
    public static final String OPERATION_OPENWINDOW_TYPE = "openwindow";
    /**
     * 编辑器操作类型
     */
    public static final String OPERATION_EDITOR_TYPE = "editor";
    /**
     * 编辑器操作类型子类型——单选
     */
    public static final String OPERATION_EDITOR_SINGLESELECT_SUBTYPE = "SELECT";

    private String code;
    private String title;
    private PageDataFilter dataFilter;
    private List<PcUiBotTmOperation> operations;

    /**
     * 提交ACTION
     */
    private List<PageAction> submitActions;
    private PageFieldMetaData showMetadatas;

    /**
     * 提交的逻辑家，是否多选，以及提交的数据源
     */
    private PageSubmitType submitType;

    /**
     * 移动--用于存放低代码设计界面的DSL布局和组件
     * 类型和PcUiBotTmDataState中一致
     */
    private List<PcUiBotTmDataState.Layout> layout;

    /**
     * 返回当前数据状态下的开窗操作配置清单
     *
     * @return
     */
    public List<PcUiBotTmOperation> getOpenWindowOperationList() {
        if (CollectionUtils.isEmpty(this.operations)) {
            return Collections.emptyList();
        }
        return this.operations.stream()
                .filter(pageTmOperation -> PageDataState.OPERATION_OPENWINDOW_TYPE
                        .equalsIgnoreCase(pageTmOperation.getOperate()))
                .collect(Collectors.toList());
    }

    /**
     * 返回当前数据状态下的单选操作配置清单
     *
     * @return
     */
    public List<PcUiBotTmOperation> getEditorSelectOperationList() {
        if (CollectionUtils.isEmpty(this.operations)) {
            return Collections.emptyList();
        }
        return this.operations.stream()
                .filter(pageTmOperation -> PageDataState.OPERATION_EDITOR_TYPE
                        .equalsIgnoreCase(pageTmOperation.getOperate())
                        && null != pageTmOperation.getEditorDefine()
                        && PageDataState.OPERATION_EDITOR_SINGLESELECT_SUBTYPE
                        .equalsIgnoreCase(pageTmOperation.getEditorDefine().getType()))
                .collect(Collectors.toList());
    }
}
