package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：UiBot设计器中的页面配置信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerPage
 * @Author: zaregoto
 * @Date: 2023/2/16 11:49
 */
@Slf4j
@Data
@NoArgsConstructor
public class UiBotDesignerPage implements Serializable {
    private static final long serialVersionUID = 8583741535119313519L;

    /**
     * 页面是否是定制页面
     */
    private Boolean isCustomize;

    /**
     * 页面内区分不同数据状态的页面配置
     */
    private List<PageDataState> dataStates;

    /**
     * 是否在tab中展示任务名称
     */
    private Boolean showTaskNameInTab;

    /**
     * 页面内不同数据状态的页面和字段相关的元信息的映射Map，必须经过初始化调用才会有值。<br/>
     * key-对应数据状态页面的id<br/>
     * value-对应数据状态页面的字段相关元数据<br/>
     */
    private Map<String, PageFieldMetaData> pageFieldMetadataMap;

    public void initDesignerPageConfig() {
        if (null == this.dataStates) {
//            throw new IllegalArgumentException("dataStates is null! initDesignerPageConfig failed!!!");
            log.error("Athena-KM returned NULL/EMPTY dataStates, PLZ CHECK THEM!");
            return;
        }
        if (null == this.pageFieldMetadataMap) {
            this.pageFieldMetadataMap = new HashMap<>(this.dataStates.size());
        }
        for (PageDataState dataState : this.getDataStates()) {
            String dataStateCode = dataState.getCode();
            PageFieldMetaData pageFieldMetaData = dataState.getShowMetadatas();
            if (null != dataStateCode && null != pageFieldMetaData) {
                this.pageFieldMetadataMap.put(dataStateCode, pageFieldMetaData);
            }
        }
    }

}