package com.digiwin.mobile.mobileuibot.designer.uibot.rule;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 设计器规则触发机制
 *
 * @author yanfeng
 * @date 2023/6/13 11:05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DesignerTrigger implements Serializable {

    private static final long serialVersionUID = 7362226910964573019L;

    /**
     * 规则触发的时机
     *
     * @see DesignerTriggerPointStatus
     * 默认值：false
     */
    private String point;

    /**
     * 枚举类型，触发的类型，sync同步规则，async异步规则
     *
     * @see DesignerTriggerType
     * 默认值：sync
     */
    private String type;

    /**
     * 必填
     * 触发的条件，表达式，value或者defaultValue规则时赋值表达的值
     * 默认值：“true”
     * <p>
     * 内置函数：
     * OLDVALUE： "condition": " OLDVALUE('arrival_date')"
     * DATE: “condition”: “ DATE(‘arrival_date’, ‘YYYY-MM-DD’)"
     * SUM: "condition": " SUM('arrival_ qty ')"
     * MULTIPLE: "condition": "MULTIPLE('arrival_qty','accepted_business_qty')"
     * DIVIDE: "condition": "DIVIDE('arrival_qty','accepted_business_qty')"
     * ADD: "condition": "ADD('arrival_qty','accepted_business_qty')"
     * SUBTRACT： "condition": "SUBTRACT('arrival_qty','accepted_business_qty')"
     */
    private String condition;

    //point= 'inSubmit'，提交按钮ID
    private String actionId;

    //对 type = ‘async’异步时必填，异步规则请求的url
    private String apiUrl;

    /**
     * 枚举类型，point= 'inSubmit'，api的请求方式post还是get
     *
     * @see DesignerTriggerApiMethodType
     * 默认值：“post”
     */
    private String apiMethodType;

    /**
     * api前缀的类型type=’async’使用
     * 可选值：atmc：atmcUrl，TM：themeMapUrl更多参考本地api.dev.json或者api.json的key
     */
    private String apiPrefixType;

    /**
     * type=’async’时必填，js参数脚本，返回的值当异步请求的内容体
     * 异步规则的parameterScript暴露：
     * rowData：当前作用所在字段的行数据，异步规则生效
     * currentControl： 规则作用的control
     * globalParameter：全局参数
     * moment： 时间工具
     * userInfo：用户信息
     * utils： 平台工具方法集合，参考core.utils.ts
     * executeContext：执行的上下文
     */
    private String parameterScript;

    //对type=’async’且 value规则时生效、可给多个schema赋值
    private String[] affectSchemaList;

    /**
     * 对type=’async’且 value规则时生效，是否需要通过js脚本自定义赋值，后期考虑去除，参数有点冗余
     * 默认值：false
     */
    private Boolean needCustomEvaluation;

    //对type=’async’且 value规则时生效，通过js脚本自定义赋值，配合needCustomEvaluation使用
    private String evaluationScript;

}
