package com.digiwin.mobile.mobileuibot.designer.uibot.rule;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author yanfeng
 * @date 2023/6/13 11:25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RelationFieldOperation implements Serializable {
    private static final long serialVersionUID = -7647868291797849730L;

    //联动类型: 'method'、'attribute'、'script’、’ color’
    private String type;

    //名称：属性名称/方法名称,当type = 'method' / 'attribute' 必填
    private String name;

    /**
     * 执行的脚本，当key = ‘script‘/’attribute’必填，key=’attribute’时，脚本返回的值赋值给name配置的属性名称;
     * connection规则里relation.operation.script脚本暴露：
     * apiData： api返回的数据，异步规则生效
     * relationControl： relation的path指向的字段
     * currentControl： 规则作用的control
     * globalParameter：全局参数
     * moment： 时间工具
     * userInfo：用户信息
     * utils： 平台工具方法集合，参考core.utils.ts
     * executeContext：执行的上下文
     * relation.operation.type为script则多一个FormControl
     */
    private String script;

}
