package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;

import java.util.List;

/**
 * <p>功能描述：UIBot设计器『操作』配置之应用器接口</p>
 * <p>应用器的作用是将设计时的操作应用到运行时UiBotModel内</p>
 * <p>主要思路：找到待处理的layout中要改的字段，然后重新包装成UiBotColumn或UiBotField类型，再丢回UiBotModel类内部，更新字段中的操作（operation）属性</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerFieldOperationService
 * @Author: zaregoto
 * @Date: 2023/2/27 12:05
 */
public interface UiBotDesignerFieldOperationApplierService {

    /**
     * 将设计器中字段的开窗操作配置，应用到UiBotModel数据上
     *
     * @param uiBotModel
     * @param openWindowTmOperationList
     */
    void applyOpenWindowOperation(UiBotModel uiBotModel, List<PcUiBotTmOperation> openWindowTmOperationList);

    /**
     * 将设计器中字段的单选操作配置，应用到UiBotModel数据上
     *
     * @param uiBotModel
     * @param singleSelectTmOperationList
     */
    void applySingleSelectOperation(UiBotModel uiBotModel, List<PcUiBotTmOperation> singleSelectTmOperationList);
}
