package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.api.*;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.*;
import com.digiwin.mobile.mobileuibot.core.component.adaptivegrid.GridGroup;
import com.digiwin.mobile.mobileuibot.core.component.avatar.Avatar;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.card.BaseCard;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.cardgroup.CardGroup;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.IndicatorChart;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.SubProgressChart;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.layout.linear.LinearLayout;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.list.container.ListContainer;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.CardListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCard;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import com.digiwin.mobile.mobileuibot.core.component.search.Search;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.standardtab.StandardTabs;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.report.UiBotModelBuildApcStandProductionProgressPageStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.LayoutComponentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.BaseDataDesignerDocumentPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.WorkbenchPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant.ENABLE_SHOW_WAY;
import static com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl.PCM_ENABLE_SHOW_WAY;

/**
 * <p>功能描述：Uibot 设计器 DSL 渲染 服务 </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerRenderManage.java
 * @Author: wangjwc
 * @Date: created at 2023/8/18 13:32
 */
@Slf4j
@Service
public class UiBotDesignerRenderService {

    public static final String LIST_MARKER = "LIST_MARKER";
    public static final List<String> LIST_CMPT = Lists.newArrayList("DW_" + ZtbViewList.COMPONENT_TYPE,
            "DW_" + CardGroup.COMPONENT_TYPE, "DW_" + EditCardList.COMPONENT_TYPE,
            "DW_" + Table.COMPONENT_TYPE, "DW_" + TaskProgressList.COMPONENT_TYPE,
            "DW_" + ListContainer.COMPONENT_TYPE);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    private static ActionServiceImpl actionService;

    @Autowired
    public void setActionService(ActionServiceImpl actionService) {
        UiBotDesignerRenderService.actionService = actionService;
    }

    @Autowired
    private LocaleService localeService;

    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;
    @Autowired
    private StartProjectPageAnalyzer startProjectPageAnalyzer;
    @Autowired
    private BaseDataPageDefineAnalyzer baseDataPageDefineAnalyzer;
    @Autowired
    private BaseDataDesignerDocumentPageBuilder baseDataDesignerDocumentPageBuilder;
    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer baseDataDoubleDocumentPageDefineAnalyzer;
    @Autowired
    private UiBotModelBuildApcStandProductionProgressPageStrategy apcStandProductionProgressPageStrategy;
    @Autowired
    private WorkbenchPageBuilder workbenchPageBuilder;
    @Autowired
    private WorkbenchPageDefineAnalyzer workbenchPageDefineAnalyzer;
    @Autowired
    private ProjectPageDefineAnalyzer projectPageDefineAnalyzer;

    public ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> buildComponentDsl(ApiRequestComponent apiRequest) {
        ComponentDslDataRequest cmptDslDataRequest = apiRequest.getComponentData();
        if (ObjectUtils.isEmpty(cmptDslDataRequest)) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "请求参数为空"));
        }
        PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(cmptDslDataRequest.getExecuteContext(), PcUiBotExecuteContext.class);

        // 获取sourceCategory
        String sourceCategory = this.getSourceCategory(executeContext, cmptDslDataRequest.getRawData(), cmptDslDataRequest.getPageId());
        if (!StringUtils.hasLength(sourceCategory)) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "sourceCategory参数为空"));
        }

        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(sourceCategory);
        // 获取作业pageDefine
        PcUiBotPageDefine pageDefine = this.getCurrentPageDefine(executeContext, cmptDslDataRequest, sourceCategory, mobilePageRawData);
        if (pageDefine == null) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "未获取到任务定义"));
        }

        // 获取当前页面的pageLayout
        UiBotPageLayout currentPageLayout = this.getCurrentPageLayout(pageDefine, cmptDslDataRequest.getPageId());
        if (currentPageLayout == null || CollectionUtils.isEmpty(currentPageLayout.getBody())) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "未匹配到对应页面"));
        }

        // 匹配对应组件
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = this.getCurrentComponentWrapper(currentPageLayout.getBody(), cmptDslDataRequest.getCmptUuid(), cmptDslDataRequest.getComponentType());
        if (componentWrapper == null) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "未匹配到对应组件"));
        }

        // 构建元数据
        Map<String, Object> dataResult = this.getRawDataMap(cmptDslDataRequest.getData(), cmptDslDataRequest.getSubmitParam(), componentWrapper.getSchema(), componentWrapper.getComponentType());
        if (CollectionUtils.isEmpty(dataResult)) {
            return ApiResponse.buildError(localeService.getLanguageValue(apiRequest.getLocale(), "构建组件的元数据为空"));
        }

        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setIsReserveWhenEmpty(true);
        cmptContext.setSkipMultiDataSource(true);
        this.buildHooks(pageDefine.getHooks(), currentPageLayout, cmptContext);
        // dataId不为空，为修改卡片，需要重新赋给构建后的card
        if (StringUtils.hasLength(cmptDslDataRequest.getDataId())) {
            cmptContext.setModifyCardDataId(cmptDslDataRequest.getDataId());
        }
        List<BaseMobileComponentWrapper<BaseMobileComponent>> baseMobileComponentWrappers = this.buildCmptDsl(cmptContext, executeContext, Lists.newArrayList(componentWrapper), dataResult, mobilePageRawData);
        return ApiResponse.buildOK().setData(this.afterCompletion(cmptDslDataRequest, baseMobileComponentWrappers));
    }

    private String getSourceCategory(PcUiBotExecuteContext executeContext, ApiRawData rawData, String pageId) {
        String sourceCategory = rawData.getString("sourceCategory");
        if (StringUtils.hasLength(sourceCategory)) {
            // 非主页面rawdata中存在此值
            return sourceCategory;
        }
        // 主页面自定义此值
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name().equals(pageId)) {
            // 任务
            if (PcUiBotPatternUtil.isModelDriven(executeContext)) {
                sourceCategory = SourceCategoryEnum.DATA_ENTRY_MODEL_DRIVEN.name();
            } else {
                sourceCategory = SourceCategoryEnum.TASK.name();
            }
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.name().equals(pageId)) {
            // 发起项目
            sourceCategory = SourceCategoryEnum.START_PROJECT.name();
        } else if (PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name().equals(pageId)) {
            // 数据录入
            sourceCategory = SourceCategoryEnum.DATA_ENTRY.name();
        } else if (PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name().equals(pageId)) {
            // 浏览页面
            sourceCategory = SourceCategoryEnum.DATA_ENTRY.name();
        } else if (PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE.name().equals(pageId)) {
            // EDIT页面
            sourceCategory = SourceCategoryEnum.DATA_ENTRY.name();
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_PAGE.name().equals(pageId)) {
            // APC-机位生产进度页面
            sourceCategory = SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name();
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_PAGE.name().equals(pageId)) {
            // 工作台页面
            sourceCategory = SourceCategoryEnum.WORKBENCH.name();
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_PAGE.name().equals(pageId)) {
            // 任务卡当责者
            sourceCategory = SourceCategoryEnum.PROJECT.name();
        } else {
            sourceCategory = "";
        }
        return sourceCategory;
    }

    private PcUiBotPageDefine getCurrentPageDefine(PcUiBotExecuteContext executeContext, ComponentDslDataRequest cmptDslDataRequest,
                                                   String sourceCategory, MobilePageRawData mobilePageRawData) {
        String pageId = cmptDslDataRequest.getPageId();
        PcUiBotPageDefine pageDefine = null;
        if (UiBotDesignerService.PAGECODE_TASK_DETAIL.equals(executeContext.getPageCode())) {
            // 任务/发起项目
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.name().equals(pageId)
                    || SourceCategoryEnum.START_PROJECT.name().equals(sourceCategory)) {
                pageDefine = startProjectPageAnalyzer.analysis(executeContext);
                this.buildCmptSubmitAction(pageDefine);
            } else if (SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name().equals(sourceCategory)) {
                // APC-机位生产进度页面
                pageDefine = JsonUtil.objectToJavaObject(apcStandProductionProgressPageStrategy.buildQueryButton(), PcUiBotPageDefine.class);
            } else {
                List<PcUiBotTaskPageDefine> pageDefines = taskPageDefineAnalyzer.analysis(null, executeContext, null);
                if (pageDefines.size() == 1) {
                    pageDefine = pageDefines.get(0);
                } else {
                    // 获取对应数据状态下的定义
                    pageDefine = pageDefines.stream().filter(define -> StringUtils.hasLength(executeContext.getDataStateCode()) && executeContext.getDataStateCode().equals(define.getDataStateCode())).findFirst().orElse(null);
                }
                if (pageDefine != null) {
                    this.buildCmptSubmitAction(pageDefine);
                }
            }
        } else if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            // 项目
            List<PcUiBotTaskPageDefine> pageDefines = projectPageDefineAnalyzer.analysis(executeContext, executeContext.getMobileDataId(), null);
            if (pageDefines.size() == 1) {
                pageDefine = pageDefines.get(0);
            } else {
                // 获取对应数据状态下的定义
                pageDefine = pageDefines.stream().filter(define -> StringUtils.hasLength(executeContext.getDataStateCode()) && executeContext.getDataStateCode().equals(define.getDataStateCode())).findFirst().orElse(null);
            }
            if (pageDefine != null) {
                this.buildCmptSubmitAction(pageDefine);
            }
        } else if (UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode())) {
            // 数据录入
            pageDefine = baseDataPageDefineAnalyzer.analysis(executeContext).get(0);
            baseDataDesignerDocumentPageBuilder.BuildActions(pageDefine, null);
            mobilePageRawData.setExtendedFields(pageDefine.getExtendedFields());
            mobilePageRawData.setDataKeys(Optional.ofNullable(pageDefine.getDataSourceSet())
                    .map(PcUiBotDataSourceSetDTO::getFirstDataQuery)
                    .map(PcUiBotDataSourceDTO::getDataKeys)
                    .orElse(null));
        } else if (UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(executeContext.getPageCode())) {
            // 浏览页面
            //数据录入2.0浏览页非默认tab, 查询任务定义需要viewCode来查询apgeUiElements
            if (StringUtils.hasLength(cmptDslDataRequest.getViewCode())) {
                PcUiBotRuntimes.getContext().put(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, cmptDslDataRequest.getViewCode());
            }

            pageDefine = baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext).get(0);
            baseDataDesignerDocumentPageBuilder.BuildActions(pageDefine, null);
            mobilePageRawData.setExtendedFields(pageDefine.getExtendedFields());
            mobilePageRawData.setDataKeys(Optional.ofNullable(pageDefine.getDataSourceSet())
                    .map(PcUiBotDataSourceSetDTO::getFirstDataQuery)
                    .map(PcUiBotDataSourceDTO::getDataKeys)
                    .orElse(null));
        } else if (UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode())) {
            // EDIT页面
            pageDefine = baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext).get(0);
            baseDataDesignerDocumentPageBuilder.BuildActions(pageDefine, null);
            mobilePageRawData.setExtendedFields(pageDefine.getExtendedFields());
            mobilePageRawData.setDataKeys(Optional.ofNullable(pageDefine.getDataSourceSet())
                    .map(PcUiBotDataSourceSetDTO::getFirstDataQuery)
                    .map(PcUiBotDataSourceDTO::getDataKeys)
                    .orElse(null));
        } else if (UiBotDesignerService.PAGECODE_WORKBENCH.equals(executeContext.getPageCode())) {
            // 工作台页面
            pageDefine = workbenchPageDefineAnalyzer.analysis(executeContext).get(0);
            workbenchPageBuilder.BuildActions(pageDefine, null);
        } else {
            pageDefine = null;
        }
        return pageDefine;
    }

    private UiBotPageLayout getCurrentPageLayout(PcUiBotPageDefine pageDefine, String pageId) {
        if (CollectionUtils.isEmpty(pageDefine.getPageLayout())) {
            return null;
        }
        UiBotPageLayout mainPageLayout = new UiBotPageLayout();
        if (Objects.nonNull(pageId) && PageSettingIdPresetEnum.getEnumByName(pageId) == null) {
            // 其它页面
            for (UiBotPageLayout uiBotPageLayout : pageDefine.getPageLayout()) {
                if (pageId.equalsIgnoreCase(uiBotPageLayout.getPageId())) {
                    mainPageLayout = uiBotPageLayout;
                    break;
                }
            }
        } else {
            // 主页面
            mainPageLayout = this.getMainPageLayout(pageDefine.getPageLayout(), null);
        }
        return mainPageLayout;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> getCurrentComponentWrapper(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, String cmptUuid, String componentType) {
        if (("DW_" + EditCardList.COMPONENT_TYPE).equals(componentType)) {
            componentType = "DW_" + ZtbViewList.COMPONENT_TYPE;
        }
        String finalComponentType = componentType;
        return body.stream().filter(wrapper -> wrapper.getComponentType().equals(finalComponentType) && wrapper.returnComponentId().equals(cmptUuid)).findFirst().orElse(null);
    }

    private Map<String, Object> getRawDataMap(Object rawData, List<ActionSubmitParam> submitParam, String schema, String componentType) {
        Map<String, Object> rawDataMap = new HashMap<>();
        if (rawData instanceof List) {
            // 数组时，需要构建节点的key
            rawDataMap.put(schema, rawData);
            return rawDataMap;
        }
        Map<String, Object> map = new HashMap<>();
        if (rawData instanceof Map) {
            map = (Map<String, Object>) rawData;
        }
        if (!CollectionUtils.isEmpty(submitParam)) {
            // 提交参数覆盖 rawdata中数据，然后在构建组件
            map.putAll(actionService.buildSubmitParasMap(submitParam).stream().collect(Collectors.toMap(DigiwinActionSubmitParas::getSchema, c -> StringUtil.valueOf(c.getValue()), (c1, c2) -> c1)));
        }
        if (LIST_CMPT.contains(componentType)) {
            if (map.containsKey(schema)) {
                // 如果是列表组件，且map中有schema，则直接返回 -- 传递过来的map就是包含列表节点的数据
                rawDataMap = map;
            } else {
                rawDataMap.put(schema, Lists.newArrayList(map));
            }
        } else {
            rawDataMap = map;
        }
        return rawDataMap;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> afterCompletion(ComponentDslDataRequest cmptDslDataRequest, List<BaseMobileComponentWrapper<BaseMobileComponent>> baseMobileComponentWrappers) {
        String dataId = cmptDslDataRequest.getDataId();
        if (CollectionUtils.isEmpty(baseMobileComponentWrappers)) {
            return null;
        }
        BaseMobileComponentWrapper<BaseMobileComponent> wrapper = baseMobileComponentWrappers.get(0);
//        if (StringUtils.hasLength(dataId)) {
//            // dataId不为空，为修改卡片，需要重新赋给构建后的card
//            if (("DW_" + EditCardList.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
//                EditCardList editCardList = (EditCardList) wrapper.getData();
//                List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = editCardList.getContentGroup();
//                if (!CollectionUtils.isEmpty(contentGroup)) {
//                    BaseMobileComponentWrapper<BaseMobileComponent> content = contentGroup.get(0);
//                    EditCard editCard = (EditCard) content.getData();
//                    editCard.setCmptUuid(dataId);
//                    editCard.setComponentId(dataId);
//                    editCard.setSchema(dataId);
//                    editCard.setDataId(dataId);
//                }
//            } else if (("DW_" + ZtbViewList.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
//                ZtbViewList ztbViewList = (ZtbViewList) wrapper.getData();
//                List<Card> cardList = ztbViewList.getData();
//                if (!CollectionUtils.isEmpty(cardList)) {
//                    Card card = cardList.get(0);
//                    card.setCmptUuid(dataId);
//                    card.setComponentId(dataId);
//                    card.setSchema(dataId);
//                    card.setDataId(dataId);
//                }
//            } else if (("DW_" + Card.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
//                Card card = (Card) wrapper.getData();
//                card.setSchema(dataId);
//                card.setDataId(dataId);
//            }
//        }
        return wrapper;
    }

    /**
     * 构建 转派按钮
     *
     * @param apiRequest
     * @param uiBotModel
     * @return
     */
    public DigiwinAtmcBacklogDetail buildApprovalReassign(ApiRequest apiRequest, UiBotModel uiBotModel) {
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(),
                apiRequest.getIamUserToken(), apiRequest.getDataId());
        if (!ObjectUtils.isEmpty(uiBotModel.getFinished()) && !uiBotModel.getFinished() && backlogDetail.backlogHasReassignData()) {
            Map<String, Object> buttonActionRawData = new HashMap<>(backlogDetail.getReassign());
            buttonActionRawData.put("appCode", backlogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", backlogDetail);
            uiBotModel.setReassignButton(Button.createApprovalReassign(backlogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK",
                    59096));
        }
        return backlogDetail;
    }

    /**
     * 构建任务卡标题
     *
     * @param apiRequest
     * @param uiBotModel
     * @param backlogDetail
     * @param isPostmark    是否包含邮戳，true：包含，false：不包含
     */
    public void buildTitleBody(ApiRequest apiRequest, UiBotModel uiBotModel, DigiwinAtmcBacklogDetail backlogDetail, Boolean isPostmark) {
        if (SsoSourceTypeEnum.NANA_MESSAGE.getSource().equals(apiRequest.getSourceType())
                && PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name().equals(apiRequest.getPageId())) {
            return;
        }
        // 判断是否是签核任务
        boolean isApproval = this.checkIsApproval(backlogDetail);
        // 判断是否包含邮戳
        isPostmark = this.checkIsPostmark(isPostmark, isApproval);
        // 构建
        String titleSchema = PcUiBotConstants.UIBOT_FIELDS_ACTIVITY;
        TitleBody titleBody = (TitleBody) ModuleUtils.buildTitle(uiBotModel,
                JsonUtil.objectToJavaObject(
                        isApproval ? uiBotModel.getPageData() : uiBotModel.getPageData().get(titleSchema),
                        new TypeReference<Map<String, Object>>() {
                        }),
                backlogDetail, apiRequest, false, isApproval, isPostmark);
        this.buildTitleDesc(titleBody, uiBotModel);
        uiBotModel.getRenderData().addWrapperedComponentToBody(
                new BaseMobileComponentWrapper<>(titleBody, "DW_" + titleBody.returnComponentType(), titleSchema));
    }

//    public void buildProjectTitleBody(ApiRequest apiRequest, UiBotModel uiBotModel) {
//        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
//        if (atmcEnginePanelInfo == null || atmcEnginePanelInfo.getTask() == null) {
//            return;
//        }
//        // 构建
//        String titleSchema = PcUiBotConstants.UIBOT_FIELDS_ACTIVITY;
//        TitleBody titleBody = (TitleBody) ModuleUtils.buildProjectTitle(
//                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(titleSchema), PcUiBotTaskData.class),
//                atmcEnginePanelInfo.getTask(), apiRequest);
//        // 构建标题的 desc
//        this.buildProjectTitleDesc(apiRequest, titleBody, atmcEnginePanelInfo.getTask());
//        uiBotModel.getRenderData().addWrapperedComponentToBody(
//                new BaseMobileComponentWrapper<>(titleBody, "DW_" + titleBody.returnComponentType(), titleSchema));
//    }

//    private void buildProjectTitleDesc(ApiRequest apiRequest, TitleBody titleBody, DigiwinAtmcPanelTask panelTask) {
//        if (null == titleBody.getContent()) {
//            titleBody.setContent(new TitleContent());
//        }
//        if (titleBody.getContent().getDesc() == null) {
//            titleBody.getContent().setDesc(new PageDesc());
//        }
//        PageDesc desc = titleBody.getContent().getDesc();
//        desc.addContent(0xe78a, ProjectStringUtil.getProjectDateDistanceString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());
//        desc.addContent(0xe78a, ProjectStringUtil.getProjectSourceInfoString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());
//        desc.addContent(0xe78a, ProjectStringUtil.getProjectInitiatorInfoString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());
//
//        Map<String, DigiwinAtmcPanelSource> sourcesByMainTaskId = this.digiwinAtmcProxyService.getSourcesByMainTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
//        if (!CollectionUtils.isEmpty(sourcesByMainTaskId)) {
//            sourcesByMainTaskId.forEach((k, v) -> desc.addContent(0xe78a, localeService.getLanguageValue(apiRequest.getLocale(), "发起时间：") + v.getStartTime(), PageDescContentTypeEnum.NORMAL.getValue()));
//        }
//    }

    /**
     * 构建机制参数和交付设计器参数
     *
     * @param apiRequest
     * @param uiBotModel
     * @param executeContext
     */
    public void buildVariablesAndDelivery(ApiRequest apiRequest, UiBotModel uiBotModel, PcUiBotExecuteContext executeContext) {
        UiBotPageData uiBotPageData = Optional.ofNullable(uiBotModel.getRawUiBotPageData()).orElse(new UiBotPageData());
        Map<String, Object> deliveryDesignerMap = Collections.emptyMap();
        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId())) {
            deliveryDesignerMap = digiwinKnowledgeMapsProxyService.executionEngine(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), "QuestionAnswer_DataPulling", Collections.emptyList());
        }
        uiBotPageData.put("uiBot__delivery", deliveryDesignerMap);
        //新增PCM的机制参数【enable_show_way】 --- 注意：原有的uiBot__variables值是List，非Map
        Map<String, Object> uiBotVariables = new HashMap<>();
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            Map<String, Object> mechanismParamValueMap = digiwinKnowledgeMapsProxyService.getMechanismParamValue(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), ENABLE_SHOW_WAY);
            if (mechanismParamValueMap != null) {
                uiBotVariables.put(ENABLE_SHOW_WAY, mechanismParamValueMap.get(ENABLE_SHOW_WAY));
            } else {
                //历史数据可能都没有配置，默认选择是，对应的是1
                uiBotVariables.put(ENABLE_SHOW_WAY, PCM_ENABLE_SHOW_WAY);
            }
        }
        // pcc 手动任务
        if ("manual_DTD_Assignment".equalsIgnoreCase(executeContext.getTmActivityId())) {
            uiBotVariables = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), Arrays.asList("isWorkReportRequired", "isworkHourZero", "isAllowReportAfter"));
        }
        uiBotPageData.put("uiBot__variables", uiBotVariables);
        uiBotModel.setRawUiBotPageData(uiBotPageData);
    }

    private Boolean checkIsPostmark(Boolean isPostmark, boolean isApproval) {
        if (isApproval) {
            // 签核型任务必显示邮戳
            return true;
        }
        return isPostmark;
    }

    private boolean checkIsApproval(DigiwinAtmcBacklogDetail backlogDetail) {
        if (backlogDetail == null) {
            return false;
        }
        /**
         * tmPattern=BUSINESS、tmCategory=DATA_ENTRY_DRIVEN
         * tmTaskId=process_****  ----- 流程设计主键id
         * tmActivityId=UserTask_**** ----- 人工签核卡节点id
         * tmActivityId=ManualTask_**** ----- 人工任务卡节点id
         */
        if (TaskStringUtil.isBizDataEntryDriven(backlogDetail.getTmPattern(), backlogDetail.getTmCategory())) {
            // 此类型卡都要标记为是签核，需要展示流程进度、邮戳
            return true;
        }
        if (TaskStringUtil.isBizApproval(backlogDetail.getTmPattern(), backlogDetail.getTmCategory())) {
            //签核类型的卡都要标记为是签核，需要展示流程进度、邮戳
            return true;
        }
        if (TaskStringUtil.isBizSmartAdjust(backlogDetail.getTmActivityId())) {
            //随心控(人工型：code+_task_manual;审核型：code+_task_approve)的卡都要标记为是签核，需要展示流程进度、邮戳
            return true;
        }
        return false;
    }

    /**
     * 封装运行态组件DSL
     *
     * @param executeContext    上下文
     * @param cmptList          设计态DSL
     * @param dataResult        原始数据
     * @param mobilePageRawData 当前请求的上下文内容（组件内传递）
     * @return
     */
//    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildCmptDsl(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList, Map<String, Object> dataResult, MobilePageRawData mobilePageRawData) {
//        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
//        return this.buildCmptDsl(cmptContext, executeContext, cmptList, dataResult, mobilePageRawData);
//    }
    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildCmptDsl(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList, Map<String, Object> dataResult, MobilePageRawData mobilePageRawData) {
        this.buildCmptRender(cmptContext, executeContext, cmptList, dataResult, mobilePageRawData);
        return cmptList;
    }

    /**
     * 处理运行态组件内容渲染
     *
     * @param cmptContext       组件构建中 上下文
     * @param executeContext    上下文
     * @param cmptList          设计态DSL
     * @param dataResult        原始数据
     * @param mobilePageRawData 当前请求的上下文内容（组件内传递）
     */
    public void buildCmptRender(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList, Map<String, Object> dataResult, MobilePageRawData mobilePageRawData) {
        if (CollectionUtils.isEmpty(cmptList)) {
            return;
        }

        // 原始的动态额外复制的组件，如GROUP_CARD
        List<BaseMobileComponentWrapper<BaseMobileComponent>> rawCopyCmptList = new ArrayList<>();
        // 动态额外复制的组件
        List<BaseMobileComponentWrapper<BaseMobileComponent>> copyCmptList = new ArrayList<>();
        int size = cmptList.size();
        cmptList.forEach(componentWrapper -> {
            String componentType = componentWrapper.getComponentType();
            String componentSchema = componentWrapper.getSchema();
            String componentMobilePath = componentWrapper.getMobilePath();
            if (("DW_" + CustomGroup.COMPONENT_TYPE).equalsIgnoreCase(componentType)) {
                // 自定义分组组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if (CollectionUtils.isEmpty(((CustomGroup) componentWrapper.getData()).getContentGroup())) {
                    // customGroup内容为空
                    if (size < 2) {
                        // 当前页面只有一个customGroup组件，则删除此组件，添加空组件（因customGroup中只有附件组件时无附件会删除附件组件）--- 为显示空组件暂无数据
                        rawCopyCmptList.add(componentWrapper);
                        copyCmptList.add(new BaseMobileComponentWrapper<>(
                                Empty.create(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "暂无数据"), true),
                                "DW_" + Empty.COMPONENT_TYPE));
                    }
                }
                // 针对于多表单，scheme一致时，导致前端渲染组件为同一个,故重置
                componentWrapper.setSchema(UUIDUtil.getUuid());
                componentWrapper.getData().setSchema(componentWrapper.getSchema());
                componentWrapper.setMobilePath(UUIDUtil.getUuid());
                componentWrapper.getData().setMobilePath(componentWrapper.getMobilePath());
            } else if (("DW_" + ButtonGroup.COMPONENT_TYPE).equalsIgnoreCase(componentType)) {
                // 按钮组 组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof ZtbViewList) {
                // 列表组件
                // 判断是否是编辑卡片列表
                if (CardListTypeEnum.EDIT_CARD_LIST.getValue().equals(((ZtbViewList) componentWrapper.getData()).getCardListType())) {
                    EditCardList editCardList = JsonUtil.objectToJavaObject(componentWrapper.getData(), EditCardList.class);
                    editCardList.handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                    // 重置列表组件
                    componentWrapper.setComponentType("DW_" + EditCardList.COMPONENT_TYPE);
                    componentWrapper.setData(editCardList);
                    if (BooleanUtils.isNotTrue(cmptContext.getIsReserveWhenEmpty())
                            && ObjectUtils.isEmpty(editCardList.getContentGroup())
                            && BooleanUtils.isNotTrue(editCardList.getCanAddOrEditCard())
                            && BooleanUtils.isNotTrue(editCardList.getCanFilterCard())
                            && BooleanUtils.isNotTrue(editCardList.getHasOperationImport())) {
                        // 列表数据为空并且无新增功能并且无筛选功能时，删除列表组件
                        rawCopyCmptList.add(componentWrapper);
                    }
                } else {
                    ZtbViewList ztbViewList = (ZtbViewList) componentWrapper.getData();
                    ztbViewList.handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                    if (BooleanUtils.isNotTrue(cmptContext.getIsReserveWhenEmpty())
                            && ObjectUtils.isEmpty(ztbViewList.getData())
                            && ObjectUtils.isEmpty(ztbViewList.getAddItemAction())
                            && ObjectUtils.isEmpty(ztbViewList.getFilterAction())
                            && BooleanUtils.isNotTrue(ztbViewList.getHasOperationImport())) {
                        // 列表数据为空并且无新增功能并且无筛选功能时，删除列表组件
//                        rawCopyCmptList.add(componentWrapper);
                    }
                }
            } else if (("DW_" + InputWindowSingleSelect.COMPONENT_TYPE).equalsIgnoreCase(componentType) || ("DW_" + InputWindowMultiSelect.COMPONENT_TYPE).equalsIgnoreCase(componentType)) {
                // 开窗单选、开窗多选
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof Button) {
                // 按钮组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof Attachment) {
                // 附件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if (AttachmentTypeEnum.READ_ONLY.getValue().equals(((Attachment<?>) componentWrapper.getData()).getType())
                        && BooleanUtils.isNotTrue(((Attachment<?>) componentWrapper.getData()).getEnable())
                        && CollectionUtils.isEmpty(((Attachment<?>) componentWrapper.getData()).getFileList())) {
                    // 附件只读，并且不可编辑，并且无数据
                    if (size < 2) {
                        // 只存在附件组件，删除此附件组件 --- 为显示空组件暂无数据
                        rawCopyCmptList.add(componentWrapper);
                    }
                }
            } else if (componentWrapper.getData() instanceof CardGroup) {
                // 卡片多选组件--列表组件
                rawCopyCmptList.add(componentWrapper);
                Optional.ofNullable((List<Map<String, Object>>) getDataByPathAndSchema(dataResult, componentMobilePath, componentSchema))
                        .orElse(new ArrayList<>())
                        .forEach(map -> {
                            BaseMobileComponentWrapper<BaseMobileComponent> copyCmpt = new BaseMobileComponentWrapper<>(JsonUtil.objectToJavaObject(componentWrapper.getData(), CardGroup.class), componentWrapper.getComponentType(), componentSchema, componentMobilePath);
                            copyCmpt.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, map, executeContext, mobilePageRawData);
                            copyCmptList.add(copyCmpt);
                        });
            } else if (componentWrapper.getData() instanceof StandardTabs) {
                // 标准Tab页签组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof AutoFill) {
                // 操作菜单组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if ("PWD_RTP_InquiryReply".equals(executeContext.getTmActivityId()) && ObjectUtils.isEmpty(dataResult.get(componentSchema.substring((AutoFill.COMPONENT_TYPE + "_").length())))) {
                    // 现带图采购使用到
                    // schema=AUTO_FILL_schema(cardList组件的schema)数据为空，则删除此组件
                    rawCopyCmptList.add(componentWrapper);
                }
            } else if (componentWrapper.getData() instanceof Webview) {
                // Webview组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if (!StringUtils.hasLength(((Webview) componentWrapper.getData()).getUrl())) {
                    // webview 组件 URL为空，则删除此组件
                    rawCopyCmptList.add(componentWrapper);
                }
            } else if (componentWrapper.getData() instanceof ProgressBar) {
                // 进度条组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof Retractable) {
                // 折叠组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof IndicatorChart) {
                // 指标卡组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof SubProgressChart) {
                // 子项进度组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof Picture) {
                // 图片组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof GridGroup) {
                // 网格组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if (CollectionUtils.isEmpty(((GridGroup) componentWrapper.getData()).getContentGroup())) {
                    if (size < 2) {
                        // 当前页面只有一个GridGroup组件，则删除此组件，添加空组件（因GridGroup中只有附件组件时无附件会删除附件组件）--- 为显示空组件暂无数据
                        rawCopyCmptList.add(componentWrapper);
                        copyCmptList.add(new BaseMobileComponentWrapper<>(
                                Empty.create(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "暂无数据"), true),
                                "DW_" + Empty.COMPONENT_TYPE));
                    }
                }
            } else if (componentWrapper.getData() instanceof LinearLayout) {
                // 线性布局组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                if (CollectionUtils.isEmpty(((LinearLayout) componentWrapper.getData()).getContentGroup())) {
                    if (size < 2) {
                        // 当前页面只有一个LinearLayout组件，则删除此组件，添加空组件（因GridGroup中只有附件组件时无附件会删除附件组件）--- 为显示空组件暂无数据
                        rawCopyCmptList.add(componentWrapper);
                        copyCmptList.add(new BaseMobileComponentWrapper<>(
                                Empty.create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "暂无数据"), true),
                                "DW_" + Empty.COMPONENT_TYPE));
                    }
                }
            } else if (componentWrapper.getData() instanceof ListContainer) {
                // 列表容器组件
                cmptContext.setListContainerCount(cmptContext.getListContainerCount() + 1);
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
                cmptContext.setListContainerCount(cmptContext.getListContainerCount() - 1);
                if (ObjectUtils.isEmpty(((ListContainer) componentWrapper.getData()).getContentGroup())) {
                    // 列表容器组件数据为空时，删除列表容器组件
                    rawCopyCmptList.add(componentWrapper);
                }
            } else if (componentWrapper.getData() instanceof Avatar) {
                // 头像组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else if (componentWrapper.getData() instanceof Search) {
                // 搜索组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            } else {
                // 普通组件
                componentWrapper.getData().handleComponentParam(cmptContext, componentMobilePath, componentSchema, dataResult, executeContext, mobilePageRawData);
            }
            // wjw FIXME: 2025/1/16 LIST_CONTAINER列表容器内组件重置componentId和schema
            if (cmptContext.getListContainerCount() != 0) {
                if (componentWrapper.getData() instanceof Card) {
                    componentWrapper.getData().setComponentId(UUIDUtil.getUuid());
                } else {
                    componentWrapper.getData().setSchema(UUIDUtil.getUuid());
                }
            }
        });
        cmptList.removeAll(rawCopyCmptList);
        cmptList.addAll(copyCmptList);
    }

    /**
     * 是否包含列表组件
     *
     * @param body
     * @return
     */
    public static boolean isContainListComponent(List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        if (CollectionUtils.isEmpty(body)) {
            return false;
        }
        for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : body) {
            if (LIST_CMPT.contains(wrapper.getComponentType())) {
                return true;
            } else if (("DW_" + CustomTabController.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
                // 列表组件可能存在tabs组件中
                CustomTabController tabController = (CustomTabController) wrapper.getData();
                for (CustomTabControllerItem tabItem : tabController.getTabItems()) {
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyList =
                            tabItem.getContentArea().getBodyArea()
                                    .stream()
                                    .map(r -> {
                                        BaseMobileComponent component = (BaseMobileComponent) r.getData();
                                        return new BaseMobileComponentWrapper<>(component, r.getContentCmptType(), r.getSchema());
                                    }).collect(Collectors.toList());
                    if (UiBotDesignerRenderService.isContainListComponent(bodyList)) {
                        // 存在列表组件，直接返回
                        return true;
                    }
                }
            } else if (wrapper.getData() instanceof SingleListContainer) {
                // 列表组件可能存在SingleListContainer组件中
                SingleListContainer<BaseMobileComponent> singleListContainer = (SingleListContainer) wrapper.getData();
                for (BaseMobileComponentWrapper<BaseMobileComponent> content : singleListContainer.getContentList()) {
                    if (LIST_CMPT.contains(content.getComponentType())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * 是否存在底部按钮
     *
     * @param renderData DSL
     * @return
     */
    public static boolean isExistBottomButton(UiBotRenderData renderData) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom = renderData.getBottom();
        if (!CollectionUtils.isEmpty(bottom)) {
            // 是否包含真正的底部按钮
            for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : bottom) {
                if (("DW_" + ButtonGroup.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
                    ButtonGroup buttonGroup = (ButtonGroup) wrapper.getData();
                    if (buttonGroup != null) {
                        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
                        if (!CollectionUtils.isEmpty(contentGroup)) {
                            return true;
                        }
                    }
                }
            }
        }
        // body中是否包含底部按钮
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = renderData.getBody();
        for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : body) {
            if (("DW_" + CustomTabController.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
                // 底部按钮可能存在tabs组件中
                CustomTabController tabController = (CustomTabController) wrapper.getData();
                for (CustomTabControllerItem tabItem : tabController.getTabItems()) {
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyList =
                            tabItem.getContentArea().getBodyArea()
                                    .stream()
                                    .map(r -> {
                                        BaseMobileComponent component = (BaseMobileComponent) r.getData();
                                        return new BaseMobileComponentWrapper<>(component, r.getContentCmptType(), r.getSchema());
                                    }).collect(Collectors.toList());
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomList =
                            tabItem.getContentArea().getBottomArea()
                                    .stream()
                                    .map(r -> {
                                        BaseMobileComponent component = (BaseMobileComponent) r.getData();
                                        return new BaseMobileComponentWrapper<>(component, r.getContentCmptType(), r.getSchema());
                                    }).collect(Collectors.toList());
                    UiBotRenderData newRenderData = UiBotRenderData.createEmptyRenderData();
                    newRenderData.addWrapperedComponentListToBody(bodyList);
                    newRenderData.addWrapperedComponentListToBottom(bottomList);
                    if (UiBotDesignerRenderService.isExistBottomButton(newRenderData)) {
                        // 存在底部按钮，直接返回
                        return true;
                    }
                }
            } else if (wrapper.getData() instanceof ZtbViewList) {
                // 底部按钮可能存在CardList组件中
                ZtbViewList ztbViewList = (ZtbViewList) wrapper.getData();
                if (!CollectionUtils.isEmpty(ztbViewList.getData())) {
                    for (Card card : ztbViewList.getData()) {
                        if (UiBotDesignerRenderService.cardIsExistBottomButton(card)) {
                            return true;
                        }
                    }
                }
            } else if (wrapper.getData() instanceof Card) {
                // 底部按钮可能存在Card组件中
                if (UiBotDesignerRenderService.cardIsExistBottomButton((Card) wrapper.getData())) {
                    return true;
                }
            } else if (wrapper.getData() instanceof SingleListContainer) {
                // 底部按钮可能存在SingleListContainer组件中
                UiBotRenderData newRenderData = UiBotRenderData.createEmptyRenderData();
                newRenderData.addWrapperedComponentListToBody(((SingleListContainer) wrapper.getData()).getContentList());
                if (UiBotDesignerRenderService.isExistBottomButton(newRenderData)) {
                    // 存在底部按钮，直接返回
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean cardIsExistBottomButton(Card card) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = card.getCardButtons();
        if (CollectionUtils.isEmpty(cardButtons)) {
            return false;
        }
        ButtonGroup buttonGroup = (ButtonGroup) cardButtons.get(0).getData();
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
        return !CollectionUtils.isEmpty(contentGroup);
    }

    /**
     * 构建标题的 desc
     *
     * @param titleBody
     * @param uiBotModel
     */
    private void buildTitleDesc(TitleBody titleBody, UiBotModel uiBotModel) {
        if (null == titleBody.getContent()) {
            titleBody.setContent(new TitleContent());
        }
        if (titleBody.getContent().getDesc() == null) {
            titleBody.getContent().setDesc(new PageDesc());
        }
        PageDesc desc = titleBody.getContent().getDesc();
        Optional<UiBotLayout> optional = uiBotModel.getLayout().stream()
                .filter(layout ->
                        PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equalsIgnoreCase(layout.getType()))
                .findFirst();
        if (!optional.isPresent() || CollectionUtils.isEmpty(optional.get().getQueryButtons())) {
            return;
        }
        UiBotTipSetting tipSetting = optional.get().getQueryButtons().get(0).getTipSetting();
        if (tipSetting == null) {
            return;
        }

        Map<String, Object> dataResult = (Map<String, Object>) uiBotModel.getPageData().get(PcLayoutEnum.APPROVAL_DESCRIPTION.getValue());
        if (dataResult == null) {
            dataResult = new HashMap<>();
        }
        addDescriptionalDataToPageDesc(tipSetting.getContent(), dataResult, desc);
    }

    /**
     * 将设计器配置的任务卡提示配置，对应构建的 uiBot__APPROVAL_DESCRIPTION 值展示在PageDesc对象中
     *
     * @param content    提示元素
     * @param dataResult 元数据
     * @param pageDesc   PageDesc对象实例
     */
    private void addDescriptionalDataToPageDesc(List<UiBotTipSetting.TipSettingElement> content, Map<String, Object> dataResult, PageDesc pageDesc) {
        if (CollectionUtils.isEmpty(content)) {
            return;
        }
        for (UiBotTipSetting.TipSettingElement element : content) {
            String fieldSchema = element.getSchema();
//            if (dataResult.containsKey(fieldSchema)) {
            String title = element.getLabel();
            String value = StringUtil.valueOf(dataResult.get(fieldSchema));
            StringJoiner sj = new StringJoiner(":");
            sj.add(title);
            sj.add(StringUtils.hasLength(value) ? value : "-");
            // 和Athena绑定写死的字段和icon的设置
            int iconData = -1;
            if ("project_no".equalsIgnoreCase(fieldSchema)) {
                iconData = 0xe78a;
            }
            if ("project_name".equalsIgnoreCase(fieldSchema)) {
                iconData = 0xe675;
            }
            if ("project_leader_name".equalsIgnoreCase(fieldSchema)) {
                iconData = 0xe789;
            }
            pageDesc.addContent(iconData, sj.toString(), PageDescContentTypeEnum.NORMAL.getValue());
//            }
        }
    }

    /**
     * 替换按钮组件中的 submitAction属性
     *
     * @param queryButton
     */
    public void buildCmptSubmitAction(UiBotQueryButton queryButton) {
        this.buildButtonSubmitAction(queryButton.getSubmitActions(), queryButton.getPageLayout());
    }

    public void buildCmptSubmitAction(PcUiBotPageDefine pageDefine) {
        List<UiBotAction> submitActions = JsonUtil.objectToJavaObject(pageDefine.getSubmitActions(), new TypeReference<List<UiBotAction>>() {
        });
        this.buildButtonSubmitAction(submitActions, pageDefine.getPageLayout());
    }

    private void buildButtonSubmitAction(List<UiBotAction> submitActions, List<UiBotPageLayout> pageLayout) {
        // 解决构建任务定义时，submitAction为空，需去除提交类按钮。bug：https://athena-devops-zentao.digiwincloud.com.cn/bug-view-166893.html
        if (/*CollectionUtils.isEmpty(submitActions) || */CollectionUtils.isEmpty(pageLayout)) {
            return;
        }
        if (submitActions == null) {
            submitActions = new ArrayList<>();
        }
        Map<String, UiBotAction> uuIdMap = submitActions.stream()
                .collect(Collectors.
                        toMap(key -> Optional.ofNullable(key.getUuid()).orElse(""), c -> c, (c1, c2) -> c1));
        pageLayout.forEach(r -> {
            r.getBody().forEach(body -> {
                if (body.getData() instanceof Button) {
                    this.handleButton(body.getSchema(), (Button<?>) body.getData(), uuIdMap);
                } else if (body.getData() instanceof ZtbViewList) {
                    ZtbViewList ztbViewList = (ZtbViewList) body.getData();
                    Card card = ztbViewList.getCardListData();
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = card.getCardButtons();
                    if (!CollectionUtils.isEmpty(cardButtons)) {
                        cardButtons.forEach(cardButton -> this.handleButtonGroup((ButtonGroup) cardButton.getData(), uuIdMap));
                    }
                } else if (body.getData() instanceof Card) {
                    Card card = (Card) body.getData();
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = card.getCardButtons();
                    if (!CollectionUtils.isEmpty(cardButtons)) {
                        cardButtons.forEach(cardButton -> this.handleButtonGroup((ButtonGroup) cardButton.getData(), uuIdMap));
                    }
                }
            });
            r.getBottom().forEach(bottom -> {
                if (bottom.getData() instanceof ButtonGroup) {
                    this.handleButtonGroup((ButtonGroup) bottom.getData(), uuIdMap);
                }
            });
        });
    }

    private void handleButtonGroup(ButtonGroup buttonGroup, Map<String, UiBotAction> uuIdMap) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
        if (CollectionUtils.isEmpty(contentGroup)) {
            return;
        }
        contentGroup.removeIf(item -> this.handleButton(item.getSchema(), item.getData(), uuIdMap));
    }

    private boolean handleButton(String schema, Button<?> button, Map<String, UiBotAction> uuIdMap) {
        UiBotAction action = button.getSubmitAction();
        if (action != null && ButtonTypeEnum.isNotJump(action.getBtnType())) {
            //平台的提交没有SubmitAction，需要隐藏掉，如退回重签
            if (CollectionUtils.isEmpty(uuIdMap.get(schema))) {
                return true;
            }
            // submitAction不为空，并且非jump跳转类型
            button.setSubmitAction(uuIdMap.get(schema));
        }
        return false;
    }

    /**
     * 根据mobilePath和schema获取对应的字段值
     *
     * @param dataResult 元数据
     * @param mobilePath schema全路径
     * @param schema     待查找的schema字段
     * @return
     */
    public static Object getDataByPathAndSchema(Map<String, Object> dataResult, String mobilePath, String schema) {
        if (CollectionUtils.isEmpty(dataResult)) {
            return null;
        }
        String path = schema;
        if (StringUtils.hasLength(mobilePath)) {
            path = mobilePath;
        }
        if (!StringUtils.hasLength(path)) {
            return null;
        }
        if (dataResult.containsKey(path)) {
            return dataResult.get(path);
        }
        if (!path.contains(".")) {
            return null;
        }
        String[] keys = path.split("\\.");
        for (int i = 0; i < keys.length - 1; i++) {
            Object o = dataResult.get(keys[i]);
            // wjw FIXME: 2023/11/8 注意：o==null,说明当前路径下字段不在元数据中，则必须继续向下查找，不能直接return
            if (o != null) {
                if (o instanceof Map) {
                    dataResult = (Map<String, Object>) o;
                } else if (o instanceof List) {
                    if (!CollectionUtils.isEmpty((List) o)) {
                        List<?> listData = (List<?>) o;
                        if (listData.get(0) instanceof Map<?, ?>) {
                            //可能存在类型转换异常
                            dataResult = (Map<String, Object>) listData.get(0);
                        }
                    }
                } else {
                    // 留空，不是集合则不做处理，继续向下查找
                }
            }
        }
        return dataResult.get(keys[keys.length - 1]);
    }

    /**
     * 根据mobilePath获取对应的字段值
     *
     * @param dataResult 元数据
     * @param mobilePath schema全路径
     * @return
     */
    public static Map<String, Object> getDataByMobilePath(Map<String, Object> dataResult, String mobilePath) {
        if (CollectionUtils.isEmpty(dataResult)) {
            return dataResult;
        }
        if (!StringUtils.hasLength(mobilePath)) {
            return dataResult;
        }
        if (dataResult.containsKey(mobilePath)) {
            return handleDataByMobilePath(dataResult, dataResult.get(mobilePath));
        }
        if (!mobilePath.contains(".")) {
            return dataResult;
        }
        String[] keys = mobilePath.split("\\.");
        for (int i = 0; i < keys.length - 1; i++) {
            Object o = dataResult.get(keys[i]);
            // wjw FIXME: 2023/11/8 注意：o==null,说明当前路径下字段不在元数据中，则必须继续向下查找，不能直接return
            if (o != null) {
                if (o instanceof Map) {
                    dataResult = (Map<String, Object>) o;
                } else if (o instanceof List) {
                    if (!CollectionUtils.isEmpty((List) o)) {
                        dataResult = ((List<Map<String, Object>>) o).get(0);
                    }
                } else {
                    // 留空，不是集合则不做处理，继续向下查找
                }
            }
        }
        return handleDataByMobilePath(dataResult, dataResult.get(keys[keys.length - 1]));
    }

    private static Map<String, Object> handleDataByMobilePath(Map<String, Object> dataResult, Object dataByMobilePath) {
        if (dataByMobilePath instanceof Map) {
            return (Map<String, Object>) dataByMobilePath;
        } else if (dataByMobilePath instanceof List) {
            if (!CollectionUtils.isEmpty((List) dataByMobilePath)) {
                return ((List<Map<String, Object>>) dataByMobilePath).get(0);
            }
        }
        return dataResult;
    }

    /**
     * 根据列表节点的path，获取列表数据
     *
     * @param schemaData 元数据
     * @param path       当前列表节点的路径
     * @param isSubimt   是否提交场景，true：是，false：否
     * @return
     */
    public static List<Map<String, Object>> getDataByPath(Map<String, Object> schemaData, String path, boolean isSubimt) {
        if (CollectionUtils.isEmpty(schemaData)) {
            return null;
        }
        if (ObjectUtils.isEmpty(path)) {
            if (isSubimt) {
                // 兼容前端path未传递情况，按理说，实际场景不会为null
                return Lists.newArrayList(schemaData);
            } else {
                return null;
            }
        }
        if (schemaData.containsKey(path)) {
            return (List<Map<String, Object>>) schemaData.get(path);
        }
        if (!path.contains(".")) {
            // path可能是根节点，故需要返回当前数据
            return Lists.newArrayList(schemaData);
        }
        List<Map<String, Object>> dataList = Lists.newArrayList(schemaData);
        String[] keys = path.split("\\.");
        for (String key : keys) {
            dataList = get(dataList, key);
        }
        return dataList;
    }

    private static List<Map<String, Object>> get(List<Map<String, Object>> dataList, String key) {
        List<Map<String, Object>> tempList = new ArrayList<>();
        // 当前层级是否包含key
        boolean anyMatch = dataList.stream().anyMatch(r -> r.containsKey(key));
        for (Map<String, Object> map : dataList) {
            Object o = map.get(key);
            if (o != null) {
                if (o instanceof Map) {
                    tempList.add((Map<String, Object>) o);
                } else if (o instanceof List) {
                    // 不改变内存地址
                    tempList = (List<Map<String, Object>>) o;
                }
            } else if (!anyMatch) {
                // 如果当前key不存在，则把当前对象添加到临时数组中，继续向下查找
                tempList.add(map);
            }
        }
        return tempList;
    }

    /**
     * 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
     * -- 方法只作用于主页面(即通过查询数据源的页面)
     *
     * @param apiRequest
     * @param uiBotModel
     * @author yanfeng
     */
    public static void handleRawPageData(ApiRequest apiRequest, UiBotModel uiBotModel) {
        if (!Lists.newArrayList(BusinessTypeEnum.LOCAL_ADD.getValue(),
                        BusinessTypeEnum.LOCAL_SAVE.getValue(),
                        BusinessTypeEnum.LOCAL_DELETE.getValue())
                .contains(apiRequest.getRawData().getBusinessType())) {
            // 卡片列表单身新增场景下 -- 非本地保存类型，置空处理
            apiRequest.setSubmitParam(null);
            apiRequest.setSubmitParams(null);
            apiRequest.setCurrentSubmitParam(null);
        }
        // 当前 表单组件
        handleAddSimpleDataOfPageData(apiRequest, uiBotModel);
        // 当前 ZtbViewList卡片列表组件
        handleAddCardListDataOfPageData(apiRequest, uiBotModel.getPageData());
    }

    private static void handleAddSimpleDataOfPageData(ApiRequest apiRequest, UiBotModel uiBotModel) {
        if (CollectionUtils.isEmpty(apiRequest.getCurrentSubmitParam())) {
            return;
        }
        Object o = uiBotModel.getPageData().get(getPageDataPath(uiBotModel));
        handleAddSimpleDataOfPageData(apiRequest, o);
    }

    public static void handleAddSimpleDataOfPageData(ApiRequest apiRequest, Object o) {
        if (CollectionUtils.isEmpty(apiRequest.getCurrentSubmitParam())) {
            return;
        }
        if (null == o) {
            return;
        }
        Map<String, Object> pageData = new HashMap<>();
        if (o instanceof Map) {
            pageData = (Map<String, Object>) o;
        } else if (o instanceof List) {
            List<Map<String, Object>> list = (List<Map<String, Object>>) o;
            if (!list.isEmpty()) {
                pageData = list.get(0);
            }
        }

        List<DigiwinActionSubmitParas> digiwinActionSubmitParasList =
                actionService.buildSubmitParasMap(apiRequest.getCurrentSubmitParam());
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));

        actionService.handleSubmitOfSimple(null, digiwinActionSubmitParasList, pageData);
    }

    public static void handleAddCardListDataOfPageData(ApiRequest apiRequest, Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(apiRequest.getSubmitParam()) || CollectionUtils.isEmpty(apiRequest.getSubmitParams())) {
            return;
        }
        //为空是新增操作
        String cardItemDataId = apiRequest.getRawData().getCardItemDataId();
        // 当前操作的cardList的mobilePath
        String currentCardListMobilePath = apiRequest.getRawData().getCurrentCardListMobilePath();
        //操作类型
        String businessType = apiRequest.getRawData().getBusinessType();

        //前端入参
        BaseCard baseCard = getActionSubmitParam(apiRequest, cardItemDataId, currentCardListMobilePath);
        // 移除无元数据时新增的一条数据
        apiRequest.getSubmitParams().removeIf(a -> Arrays.asList(EditCard.COMPONENT_TYPE, Card.COMPONENT_TYPE).contains(a.getType()) && a.getParams() == null);
        apiRequest.getSubmitParams()
                .stream()
                .collect(Collectors.groupingBy(ActionSubmitParam::getMobilePath))
                .forEach((k, v) -> {
                    List<Map<String, Object>> mapList = new ArrayList<>();
                    if (baseCard.getMobilePath().equals(k)) {
                        // 当前操作的cardList组件内容
                        handleCurrentCardListData(baseCard, businessType, mapList, v);
                    } else {
                        // 其他cardList组件内容
                        v.forEach(param -> mapList.add(((BaseCard) param.getParams()).getRawData()));
                    }

                    if (PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString().equalsIgnoreCase(apiRequest.getPageId())) {
                        resetCardListDataOfPageDataByStartProject(k, pageData, mapList);
                    } else {
                        // 重置pagedata中列表数据
                        resetCardListDataOfPageData(k, pageData, mapList);
                    }

                });
    }

    private static void handleCurrentCardListData(BaseCard baseCard, String businessType, List<Map<String, Object>> mapList, List<ActionSubmitParam> submitParamList) {
        for (ActionSubmitParam param : submitParamList) {
            BaseCard paramCard = (BaseCard) param.getParams();
            //新增
            if (StringUtil.isEmpty(baseCard.getDataId())) {
                mapList.add(paramCard.getRawData());
            } else {
                if (BusinessTypeEnum.LOCAL_SAVE.getValue().equalsIgnoreCase(businessType)) {
                    //编辑
                    if (baseCard.getDataId().equalsIgnoreCase(paramCard.getDataId())) {
                        paramCard.getRawData().putAll(baseCard.getRawData());
                    }
                    mapList.add(paramCard.getRawData());
                }
                if (BusinessTypeEnum.LOCAL_DELETE.getValue().equalsIgnoreCase(businessType)) {
                    //删除
                    if (!baseCard.getDataId().equalsIgnoreCase(paramCard.getDataId())) {
                        mapList.add(paramCard.getRawData());
                    }
                }
            }
        }
    }

    private static void resetCardListDataOfPageData(String mobilePath, Map<String, Object> pageData, List<Map<String, Object>> mapList) {
        if (pageData.containsKey(mobilePath)) {
            // 最外层列表新增场景
            pageData.put(mobilePath, mapList);
            return;
        }
        if (!mobilePath.contains(".")) {
            // 节点不存在
            return;
        }
        String[] keys = mobilePath.split("\\.");
        for (int i = 0; i < keys.length - 1; i++) {
            Object o = pageData.get(keys[i]);
            if (o != null) {
                if (o instanceof Map) {
                    pageData = (Map<String, Object>) o;
                } else if (o instanceof List) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) o;
                    if (!list.isEmpty()) {
                        pageData = list.get(0);
                    }
                }
            }
        }
        pageData.put(keys[keys.length - 1], mapList);
    }

    private static void resetCardListDataOfPageDataByStartProject(String mobilePath, Map<String, Object> pageData, List<Map<String, Object>> mapList) {
        if (pageData.containsKey(mobilePath)) {
            // 最外层列表新增场景
            Object pageDataByPath = pageData.get(mobilePath);
            if (pageDataByPath instanceof List) {
                List<Map<String, Object>> pageDataListByPath = (List<Map<String, Object>>) pageDataByPath;
                pageDataByPath = pageDataListByPath.get(0);
            }

            // 数据源的部分信息需要保留，如projectCode，name
            Object finalPageDataByPath = pageDataByPath;
            List<Map<String, Object>> handledList = mapList.stream().map(e -> {
                Map<String, Object> copyPageDataByPath = JsonUtil.objectToJavaObject(finalPageDataByPath, Map.class);
                copyPageDataByPath.putAll(e);
                return copyPageDataByPath;
            }).collect(Collectors.toList());
            pageData.put(mobilePath, handledList);
            return;
        }
        if (!mobilePath.contains(".")) {
            // 节点不存在
            return;
        }
        String[] keys = mobilePath.split("\\.");
        for (int i = 0; i < keys.length - 1; i++) {
            Object o = pageData.get(keys[i]);
            if (o != null) {
                if (o instanceof Map) {
                    pageData = (Map<String, Object>) o;
                } else if (o instanceof List) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) o;
                    if (!list.isEmpty()) {
                        pageData = list.get(0);
                    }
                }
            }
        }
        pageData.put(keys[keys.length - 1], mapList);
    }

    private static String getPageDataPath(UiBotModel uiBotModel) {
        Optional<UiBotLayout> optional = uiBotModel.getLayout().stream()
                .filter(layout ->
                        PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equalsIgnoreCase(layout.getType()))
                .findFirst();
        if (!optional.isPresent() || CollectionUtils.isEmpty(optional.get().getQueryButtons())) {
            return null;
        }
        List<UiBotQueryButton> queryButtonList = optional.get().getQueryButtons();
        return getPath(queryButtonList.get(0));
    }

    private static BaseCard getActionSubmitParam(ApiRequest apiRequest, String cardItemDataId, String currentCardListMobilePath) {
        String tmActivityId = apiRequest.getRawData().getString("dataId");

        // 卡片详情页提交参数
        List<DigiwinActionSubmitParas> digiwinActionSubmitParas = actionService.buildSubmitParasMap(apiRequest.getSubmitParam());
        // key:card的mobilePath；value:card的rawdata
        Map<String, List<Map<String, Object>>> localCardDataMap = digiwinActionSubmitParas.stream()
                .filter(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()))
                .findFirst()
                .map(r -> (List<DigiwinActionSubmitParas>) r.getValue())
                .orElse(new ArrayList<>())
                .stream()
                .collect(Collectors
                        .groupingBy(DigiwinActionSubmitParas::getMobilePath, Collectors
                                .mapping(r -> (Map<String, Object>) r.getValue(), Collectors.toList())));
        digiwinActionSubmitParas.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
        digiwinActionSubmitParas.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));
        Map<String, Object> dataMap = new HashMap<>(digiwinActionSubmitParas.size());
        for (DigiwinActionSubmitParas paras : digiwinActionSubmitParas) {
            String key = paras.getSchema();

            if ("start_SCH_mainline_project_0001".equalsIgnoreCase(tmActivityId)) {
                if ("attachment".equals(paras.getSchema())) {

                    // open issue 单选开船detail会存在附件，直接替换会把页面真正的附件信息覆盖掉，需要过滤下
                    if (paras.getMobilePath().startsWith("task_name_index") || paras.getMobilePath().startsWith("remind_task_name_index")) {
                        continue;
                    }

                    // open issue 附件需要根据状态来真正删除
                    UiBotAttachment uiBotAttachment = JsonUtil.objectToJavaObject(paras.getValue(), UiBotAttachment.class);
                    uiBotAttachment.setData(uiBotAttachment.getData().stream().filter(e -> !"DELETE".equalsIgnoreCase(e.getUibotStatus())).collect(Collectors.toList()));
                    paras.setValue(uiBotAttachment);
                }

            }
            dataMap.put(key, paras.getValue());
        }

        localCardDataMap.forEach((k, v) -> {
            if (k == null) {
                return;
            }
            if (!k.contains(".")) {
                dataMap.put(k, v);
                return;
            }
            String[] split = k.split("\\.");
            dataMap.put(split[split.length - 1], v);
        });


        if ("start_SCH_mainline_project_0001".equalsIgnoreCase(tmActivityId)) {
            List<ActionSubmitParam> taskNameParams = apiRequest.getSubmitParam().stream().filter(e -> {
                if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(e.getType()) && e.getSchema().startsWith("task_name_index")) {
                    InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(e.getParams(), InputWindowSingleSelect.class);
                    return StringUtil.isNotEmpty(inputWindowSingleSelect.getSelectId());
                }
                return false;
            }).collect(Collectors.toList());

            if (CollectionUtils.isEmpty(taskNameParams)) {
                dataMap.put("task_name", "");
                dataMap.put("question_list_task_storage_info", Collections.emptyList());
            }

            List<ActionSubmitParam> remindTaskNameParams = apiRequest.getSubmitParam().stream().filter(e -> {
                if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(e.getType()) && e.getSchema().startsWith("remind_task_name_index")) {
                    InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(e.getParams(), InputWindowSingleSelect.class);
                    return StringUtil.isNotEmpty(inputWindowSingleSelect.getSelectId());
                }
                return false;
            }).collect(Collectors.toList());

            if (CollectionUtils.isEmpty(remindTaskNameParams)) {
                dataMap.put("remind_task_name", "");
                dataMap.put("remind_list_task_storage_info", Collections.emptyList());
            }
        }

        // 获取当前新增的卡片类型
        String type = apiRequest.getSubmitParams().stream().filter(r -> Arrays.asList(EditCard.COMPONENT_TYPE, Card.COMPONENT_TYPE).contains(r.getType()) && Objects.equals(currentCardListMobilePath, r.getMobilePath())).findFirst().map(ActionSubmitParam::getType).orElse(null);
        ActionSubmitParam actionSubmitParam = new ActionSubmitParam();
        actionSubmitParam.setId(cardItemDataId);
        actionSubmitParam.setSchema(cardItemDataId);
        actionSubmitParam.setMobilePath(currentCardListMobilePath);
        actionSubmitParam.setType(type);
        BaseCard baseCard;
        if ((EditCard.COMPONENT_TYPE).equals(type)) {
            baseCard = new EditCard();
        } else {
            baseCard = new Card();
        }
        actionSubmitParam.setParams(baseCard);

        baseCard.setDataId(cardItemDataId);
        baseCard.setRawData(dataMap);
        baseCard.setMobilePath(currentCardListMobilePath);
        //null 为新增
        if (StringUtil.isEmpty(baseCard.getDataId())) {
            dataMap.put(PcUiBotConstants.MOBILE_CARD_ADD_DATA_TAG_KEY, PcUiBotConstants.MOBILE_CARD_ADD_DATA_TAG_KEY);
            apiRequest.getSubmitParams().add(actionSubmitParam);
        }
        return baseCard;
    }


    /**
     * 获取数据源名称
     *
     * @param queryButton
     * @return
     */
    public static String getPath(UiBotQueryButton queryButton) {
        if (queryButton != null && queryButton.getDataSourceSet() != null) {
            PcUiBotDataSourceSetDTO dataSourceSetDTO =
                    JsonUtil.objectToJavaObject(queryButton.getDataSourceSet(),
                            new TypeReference<PcUiBotDataSourceSetDTO>() {
                            });
            if (dataSourceSetDTO != null) {
                return dataSourceSetDTO.getMainDatasource();
            }
        }
        return null;
    }

    /**
     * 根据schema 获取dataResult里面对应数据
     *
     * @param dataResult
     * @param schema
     * @return
     */
    public static Object getDataBySchema(Map<String, Object> dataResult, String schema) {

        if (ObjectUtils.isEmpty(dataResult)) {
            return null;
        }
        if (dataResult.containsKey(schema)) {
            return dataResult.get(schema) == null ? new Object() : dataResult.get(schema);
        }
        if (schema.contains(".")) {
            schema = schema.substring(schema.lastIndexOf(".") + 1);
        }
        for (Map.Entry<String, Object> entry : dataResult.entrySet()) {
            Object obj = null;
            Object value = entry.getValue();
            if (value instanceof Map) {
                obj = getDataBySchema((Map<String, Object>) value, schema);
            } else if (value instanceof List) {
                List<Object> list = (List) value;
                if (!CollectionUtils.isEmpty(list)) {
                    for (Object o : list) {
                        if (o instanceof Map) {
                            obj = getDataBySchema((Map<String, Object>) o, schema);
                        }
                    }
                }
            }
            if (!ObjectUtils.isEmpty(obj)) {
                return obj;
            }
        }
        return null;
    }

    /**
     * 获取外层容器类型
     *
     * @param body
     * @return bodyContainerType 页面渲染DSL中body最外层要套的容器类型。0-不使用容器，1-使用单层容器，2-使用多层容器。
     */
    public static int getBodyContainerType(List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        int bodyContainerType = 1;
        if (CollectionUtils.isEmpty(body)) {
            return bodyContainerType;
        }
        for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : body) {
            if (("DW_" + StandardTabs.COMPONENT_TYPE).equals(wrapper.getComponentType())) {
                return 0;
            } else if (wrapper.getData() instanceof SingleListContainer) {
                return 0;
            }
        }
        return bodyContainerType;
    }

    /**
     * 获取主页面布局
     *
     * @param pageLayout
     * @param componentType
     * @return
     */
    public UiBotPageLayout getMainPageLayout(List<UiBotPageLayout> pageLayout, String componentType) {
        UiBotPageLayout mainPageLayout = new UiBotPageLayout();
        for (UiBotPageLayout uiBotPageLayout : pageLayout) {
            if (LayoutComponentTypeEnum.SINGLE_HEAD.getValue().equalsIgnoreCase(componentType)) {
                if (LayoutComponentTypeEnum.SINGLE_HEAD.getValue().equalsIgnoreCase(uiBotPageLayout.getComponentType())) {
                    mainPageLayout = uiBotPageLayout;
                    break;
                }
            } else {
                if (LayoutComponentTypeEnum.MAIN_PAGE.getValue().equalsIgnoreCase(uiBotPageLayout.getComponentType())) {
                    mainPageLayout = uiBotPageLayout;
                    // 因set-up-page可能会存在多个页面， 取第一个，为主页面
                    break;
                }
            }
        }
        return mainPageLayout;
    }

    public void buildMainPageHooksByPageDefine(PcUiBotPageDefine pageDefine, ComponentContext cmptContext, UiBotModel uiBotModel, String componentType) {
        List<UiBotPageLayout> pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            return;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = this.getMainPageLayout(pageLayout, componentType);
        uiBotModel.setHooks(this.buildHooks(pageDefine.getHooks(), mainPageLayout, cmptContext));
    }

    public void buildMainPageHooksByQueryButton(UiBotQueryButton queryButton, ComponentContext cmptContext, UiBotModel uiBotModel, String componentType) {
        List<UiBotPageLayout> pageLayout = queryButton.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            return;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = this.getMainPageLayout(pageLayout, componentType);
        uiBotModel.setHooks(this.buildHooks(queryButton.getHooks(), mainPageLayout, cmptContext));
    }

    /**
     * 过滤出指定页面ComponentId所对应的高级属性-页面级
     */
    public Map<String, Object> buildHooks(List<Map<String, Object>> hooks, UiBotPageLayout uiBotPageLayout, ComponentContext cmptContext) {
        // 高级属性
        if (CollectionUtils.isEmpty(hooks)) {
            return null;
        }
        cmptContext.setHooks(hooks);
        return hooks.stream()
                .filter(e -> Objects.equals(uiBotPageLayout.getComponentId(), MapUtils.getString(e, "eventSource")))
                .findFirst().orElse(null);
    }

    public void buildSmartAdjustBottomButton(ApiRequest apiRequest, UiBotModel uiBotModel) {
        Optional<UiBotLayout> optional = uiBotModel.getLayout().stream()
                .filter(layout ->
                        PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equalsIgnoreCase(layout.getType()))
                .findFirst();
        if (!optional.isPresent() || CollectionUtils.isEmpty(optional.get().getQueryButtons())) {
            return;
        }
        UiBotQueryButton queryButton = optional.get().getQueryButtons().get(0);
        PcUiBotTaskPageDefine pageDefine = JsonUtil.objectToJavaObject(queryButton, PcUiBotTaskPageDefine.class);
        List<UiBotPageLayout> pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            return;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = this.getMainPageLayout(pageLayout, null);
        // 设置底部按钮 -- 不使用设计器配置的底部按钮
        mainPageLayout.getBottom().clear();
        mainPageLayout.setBottom(this.buildBottom(pageDefine.getSubmitActions(), pageDefine.getDataSourceSet().getMainDatasource(), uiBotModel, apiRequest));
        optional.get().getQueryButtons().set(0, JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class));
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(submitActions, dataSourceName, uiBotModel, apiRequest));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        if (CollectionUtils.isEmpty(submitActions)) {
            return contentGroup;
        }
        for (PcUiBotSubmitAction submitAction : submitActions) {
            switch (submitAction.getId() == null ? "" : submitAction.getId()) {
                // 提交/保存 人工任务出现
                case "confirm":
                    contentGroup.add(this.buildSubmitButton(submitAction));
                    break;
                // 同意、不同意、加签、退回重办、退回重签 构建额外参数，button中才构建跳转V1的action
                case "agree":
                case "disagree":
                case "athena_bpm_add_task":
                case "reexecute":
                case "athena_bpm_reapprove":
                    contentGroup.add(this.buildJumpV1Button(submitAction));
                    break;
                default:
            }
        }
        // 反转顺序
        Collections.reverse(contentGroup);
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildJumpV1Button(PcUiBotSubmitAction submitAction) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(true);

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));
        // button类中 转成跳转V1页面按钮，必须设置scheme与uuid/btnId一致，因为buildCmptSubmitAction方法中需要
        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, submitAction.getUuid());
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSubmitButton(PcUiBotSubmitAction submitAction) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        // 刷新当前页
        uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, submitAction.getUuid());
    }
}