package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：UIBot设计器服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerService
 * @Author: zaregoto
 * @Date: 2023/2/27 11:46
 */
public interface UiBotDesignerService {

    /**
     * app端工作台页面代号
     */
    String PAGECODE_WORKBENCH = "workbench-mobile";
    /**
     * app端基础资料录入页面代号- 单档多栏(模型驱动)，界面
     */
    String PAGECODE_BASIC_DATA = "basic-data-mobile";
    /**
     * app端基础资料录入页面代号-双档，浏览页面
     */
    String PAGECODE_BROWSE_PAGE = "browse-page-mobile";

    /**
     * app端基础资料录入页面代号-双档，EDIT页面
     */
    String PAGECODE_EDIT_PAGE = "edit-page-mobile";
    /**
     * app端任务详情页面代号
     */
    String PAGECODE_TASK_DETAIL = "task-detail-mobile";

    /**
     * pc端任务详情页面代号
     */
    String PC_PAGECODE_TASK_DETAIL = "task-detail";

    /**
     * app端项目详情页面代号
     */
    String PAGECODE_PROJECT_DETAIL = "project-detail-mobile";

    /**
     * app端任务详情字段tag类型
     */
    String TAG_TYPE_TASK = "performer";

    /**
     * app端项目详情字段tag类型
     */
    String TAG_TYPE_PROJECT = "charge";


    /**
     * 依设计器中得到业务字段的『内容与顺序』配置，应用到PC UiBot提供的字段中
     *
     * @param uiBotModel
     * @param uiBotDesignerConfig
     */
    void applyFieldAndOrder(UiBotModel uiBotModel, final UiBotDesignerConfig uiBotDesignerConfig);

    void applyFieldTag(UiBotModel uiBotModel, final UiBotDesignerConfig uiBotDesignerConfig);

    void applyFieldRule(UiBotModel uiBotModel, final UiBotDesignerConfig uiBotDesignerConfig);

    /**
     * 依设计器中得到业务字段的『操作』配置，应用到PC UiBot提供的字段中
     *
     * @param uiBotModel
     * @param uiBotDesignerConfig
     */
    void applyFieldOperation(UiBotModel uiBotModel, final UiBotDesignerConfig uiBotDesignerConfig);
}
