package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataState;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：UI Bot相关设计器服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDesignerServiceImpl
 * @Author: zaregoto
 * @Date: 2023/2/27 11:54
 */
@Slf4j
@Service("uiBotDesignerService")
public class UiBotDesignerServiceImpl implements UiBotDesignerService {

    private final UiBotDesignerFieldAndOrderApplierService uiBotDesignerFieldAndOrderApplierService;

    private final UiBotDesignerFieldOperationApplierService uiBotDesignerFieldOperationApplierService;

    private final UiBotDesignerFieldTagApplierService uiBotDesignerFieldTagApplierService;

    public UiBotDesignerServiceImpl(UiBotDesignerFieldAndOrderApplierService uiBotDesignerFieldAndOrderApplierService, UiBotDesignerFieldOperationApplierService uiBotDesignerFieldOperationApplierService, UiBotDesignerFieldTagApplierService uiBotDesignerFieldTagApplierService) {
        this.uiBotDesignerFieldAndOrderApplierService = uiBotDesignerFieldAndOrderApplierService;
        this.uiBotDesignerFieldOperationApplierService = uiBotDesignerFieldOperationApplierService;
        this.uiBotDesignerFieldTagApplierService = uiBotDesignerFieldTagApplierService;
    }

    @Override
    public void applyFieldAndOrder(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        this.uiBotDesignerFieldAndOrderApplierService.applyFieldAndOrder(uiBotModel, uiBotDesignerConfig);
    }

    @Override
    public void applyFieldTag(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        this.uiBotDesignerFieldTagApplierService.applyFieldTag(uiBotModel, uiBotDesignerConfig);
    }

    @Override
    public void applyFieldRule(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        //只有v2版本的DSL时增加
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
            List<UiBotRule> rules = uiBotDesignerConfig.getRuleConfigs().stream()
                    .filter(rule -> !CollectionUtils.isEmpty(rule.getContentMobile()))
                    .map(rule -> {
                        UiBotRule uiBotRule = JsonUtil.objectToJavaObject(rule.getContentMobile(), UiBotRule.class);
                        uiBotRule.setName(rule.getName());

                        // 规则trigger 中如果apiPrefixType有值，apiUrl需要拼接上对应前缀
                        Optional<String> apiPrefixType = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiPrefixType);
                        if (apiPrefixType.isPresent() && StringUtils.isNotEmpty(apiPrefixType.get().trim())) {
                            String prefixUrl = AppContext.getUrl(apiPrefixType.get());
                            Optional<String> apiUrl = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiUrl);
                            if (apiUrl.isPresent() && StringUtils.isNotEmpty(apiUrl.get().trim())) {
                                uiBotRule.getTrigger().setApiUrl(prefixUrl + apiUrl.get());
                            }
                        }
                        return uiBotRule;
                    })
                    .collect(Collectors.toList());
            uiBotModel.setRules(rules);
        }
    }

    @Override
    public void applyFieldOperation(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        List<PcUiBotTmOperation> openWindowPageTmOperationList = new ArrayList<>(1);
        List<PcUiBotTmOperation> singleSelectPageTmOperationList = new ArrayList<>(1);
        /**
         * FIXME
         * 目前做法：将第1个数据状态中配置的操作提取出来，再分别重新包装成UiBotColumn或UiBotField类型，然后交由原有uibot页面生成逻辑处理。
         * 特殊情况目前未考虑：
         * 1. 如果在不同数据状态下，对相同的业务字段配置了不同的操作（如在A数据状态下对field1配置了开窗，在B数据状态下对field1配置了单选
         */
        for (int i = 0; i < uiBotDesignerConfig.getPage().getDataStates().size(); i++) {
            if (i == 1) {
                break;
            }
            PageDataState pageDataState = uiBotDesignerConfig.getPage().getDataStates().get(i);
            List<PcUiBotTmOperation> pageTmOperationList = pageDataState.getOperations();
            if (CollectionUtils.isEmpty(pageTmOperationList)) {
                break;
            }
            openWindowPageTmOperationList = pageDataState.getOpenWindowOperationList();
            singleSelectPageTmOperationList = pageDataState.getEditorSelectOperationList();
        }
        this.uiBotDesignerFieldOperationApplierService.applyOpenWindowOperation(uiBotModel, openWindowPageTmOperationList);
        this.uiBotDesignerFieldOperationApplierService.applySingleSelectOperation(uiBotModel, singleSelectPageTmOperationList);
    }
}
