package com.digiwin.mobile.mobileuibot.designer.uibot.support;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineButtonDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefineButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionDataSourceAnalysisService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.NewTaskSubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.SubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskSubmitActionCreateService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot开窗配置解析器（搬PC后端代码并修改实体类名后得到）</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotOpenWindowDefineAnalyzer
 * @Author: zaregoto
 * @Date: 2023/2/28 14:17
 */
@Component
public class PcUiBotOpenWindowDefineAnalyzer {

    @Autowired
    private SubmitActionCreateService submitActionCreateService;

    @Autowired
    private ActionDataSourceAnalysisService tmActionDataSourceService;

    @Autowired
    private TaskSubmitActionCreateService taskSubmitActionCreateService;

    @Autowired
    private NewTaskSubmitActionCreateService newTaskSubmitActionCreateService;

    /**
     * PC UI Bot分析开窗逻辑
     *
     * @param executeContext
     * @param pageTmOperation
     * @return
     */
    public PcUiBotOpenWindowDefineDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmOperation pageTmOperation, Boolean isFlowEngine) {
        /* Map bpmData = new HashMap();
        if (executeContext.getTaskWithBacklogData() != null && executeContext.getTaskWithBacklogData().getBpmData() != null) {
            bpmData = executeContext.getTaskWithBacklogData().getBpmData();
        }*/
        PcUiBotOpenWindowDefineDTO openwindowDefineDTO = new PcUiBotOpenWindowDefineDTO();
        /**
         * xuxx 2022-02-10 add 是否开启分页
         */
        if (pageTmOperation.getOpenWindowDefine().getUseHasNext() != null) {
            openwindowDefineDTO.setUseHasNext(pageTmOperation.getOpenWindowDefine().getUseHasNext());
        }
        /**
         * xuxx 2022-03-07 add 是否开启高级查询
         */
        if (pageTmOperation.getOpenWindowDefine().getEnableAdvancedSearch() != null) {
            openwindowDefineDTO.setEnableAdvancedSearch(pageTmOperation.getOpenWindowDefine().getEnableAdvancedSearch());
        }
        /**
         * xuxx 2022-03-07 add 是否开启调用API查询
         */
        if (pageTmOperation.getOpenWindowDefine().getEnableSearchByApi() != null) {
            openwindowDefineDTO.setEnableSearchByApi(pageTmOperation.getOpenWindowDefine().getEnableSearchByApi());
        }

        openwindowDefineDTO.setParameterType(pageTmOperation.getOpenWindowDefine().getParameterType());
        openwindowDefineDTO.setTitle(pageTmOperation.getOpenWindowDefine().getTitle());
        openwindowDefineDTO.setCategory(pageTmOperation.getOpenWindowDefine().getCategory());
        openwindowDefineDTO.setStyle(pageTmOperation.getOpenWindowDefine().getStyle());
        openwindowDefineDTO.setReturnFields(pageTmOperation.getOpenWindowDefine().getReturnFields());
        openwindowDefineDTO.setMultipleSelect(pageTmOperation.getOpenWindowDefine().getMultipleSelect());
        openwindowDefineDTO.setMergeKey(pageTmOperation.getOpenWindowDefine().getMergeKey());
        openwindowDefineDTO.setSelectedFirstRow(pageTmOperation.getOpenWindowDefine().getSelectedFirstRow());
        openwindowDefineDTO.setGetDataAction(
                this.createPage(executeContext, pageTmOperation.getOpenWindowDefine().getGetDataAction(), new HashMap(),
                        pageTmOperation.getOpenWindowDefine().getUseHasNext()));
        if (pageTmOperation.getOpenWindowDefine().getSuggestAction() != null) {
            pageTmOperation.getOpenWindowDefine().getSuggestAction().setName("suggestActionName");
        }
        if (pageTmOperation.getOpenWindowDefine().getAllAction() != null) {
            pageTmOperation.getOpenWindowDefine().getAllAction().setName("allActionName");
        }
        openwindowDefineDTO.setAllAction(
                this.createPage(executeContext, pageTmOperation.getOpenWindowDefine().getAllAction(), new HashMap(),
                        pageTmOperation.getOpenWindowDefine().getUseHasNext()));
        openwindowDefineDTO.setSuggestAction(
                this.createPage(executeContext, pageTmOperation.getOpenWindowDefine().getSuggestAction(), new HashMap(),
                        pageTmOperation.getOpenWindowDefine().getUseHasNext()));
        //xuxx - edit 2021-08-25 修改开窗推荐和全部数据源合并，这里是将推荐数据源拼接到最后了，在解析的时候，需注意处理逻辑
        openwindowDefineDTO.setSupportBatch(false);//默认所有开窗都不支持批量多选；如果需要后面处理；

        if (openwindowDefineDTO.getSuggestAction() != null && openwindowDefineDTO.getAllAction() != null) {
            openwindowDefineDTO.getAllAction().getDataSourceSet().getDataSourceList().addAll(
                    openwindowDefineDTO.getSuggestAction().getDataSourceSet().getDataSourceList());
            openwindowDefineDTO.setSuggestAction(null);
        }
        if (openwindowDefineDTO.getAllAction() == null && openwindowDefineDTO.getSuggestAction() != null) {
            openwindowDefineDTO.setAllAction(openwindowDefineDTO.getSuggestAction());
            openwindowDefineDTO.setSuggestAction(null);
        }

        // 表头增加多选批量开窗的逻辑，默认不配置时为false不支持表头开窗，配置后以配置为准；
        if (pageTmOperation.getOpenWindowDefine().getSupportBatch() != null) {
            openwindowDefineDTO.setSupportBatch(pageTmOperation.getOpenWindowDefine().getSupportBatch());
        } else {
            openwindowDefineDTO.setSupportBatch(false);
        }
        openwindowDefineDTO.setGetDataActions(
                this.createActivityQueryDTOS(executeContext, pageTmOperation,
                        pageTmOperation.getOpenWindowDefine().getMultipleSelect(), pageTmOperation.getOpenWindowDefine().getUseHasNext()));
        openwindowDefineDTO.setButtons(this.createButtons(executeContext, pageTmOperation, isFlowEngine));
        openwindowDefineDTO.setApplyToArray(pageTmOperation.getOpenWindowDefine().getApplyToArray());

        // 用于回填到集合的集合字段名
        String applyToField = pageTmOperation.getOpenWindowDefine().getApplyToField();
        openwindowDefineDTO.setApplyToField(StringUtils.isEmpty(applyToField) ? pageTmOperation.getApplyToField() : applyToField);

        /**
         * 解析开窗中的submitAction提交按钮
         * @author majfa
         * @date 2021/5/10
         */
        openwindowDefineDTO.setSubmitActions(createSubmitAction(executeContext, pageTmOperation, pageTmOperation.getOpenWindowDefine().getSubmitActions()));
        openwindowDefineDTO.setIsCustomize(pageTmOperation.getOpenWindowDefine().getIsCustomize());

        /**
         * 开窗标准配置字段
         */
        openwindowDefineDTO.setRoleAttention(pageTmOperation.getOpenWindowDefine().getRoleAttention());
        openwindowDefineDTO.setPrimaryField(pageTmOperation.getOpenWindowDefine().getPrimaryField());
        openwindowDefineDTO.setFields(pageTmOperation.getOpenWindowDefine().getFields());
        openwindowDefineDTO.setMobileDrilDown(pageTmOperation.getOpenWindowDefine().getMobileDrilDown());
        openwindowDefineDTO.setMobileSortInfo(pageTmOperation.getOpenWindowDefine().getMobileSortInfo());

        if (!CollectionUtils.isEmpty(pageTmOperation.getOpenWindowDefine().getLayout())) {
            openwindowDefineDTO.setLayout(pageTmOperation.getOpenWindowDefine().getLayout());
            //openwindowDefineDTO.setLayout(designerDslLayoutService.analysisLayoutDsl(tmOperation.getOpenWindowDefine().getLayout()));
        }

        return openwindowDefineDTO;
    }

    private List<PcUiBotPageDefine> createActivityQueryDTOS(PcUiBotExecuteContext executeContext,
                                                            PcUiBotTmOperation tmOperation, Boolean multipleSelect, Boolean useHasNext) {

        List<PcUiBotPageDefine> pageDefines = new ArrayList<>();
        List<PcUiBotTmQueryAction> getDataActions = tmOperation.getOpenWindowDefine().getGetDataActions();
        if (!CollectionUtils.isEmpty(getDataActions)) {
            getDataActions.forEach(getDataAction -> {
                /*Map bpmData = new HashMap();
                if(executeContext.getTaskWithBacklogData()!=null && executeContext.getTaskWithBacklogData().getBpmData()!=null) {
                    bpmData = executeContext.getTaskWithBacklogData().getBpmData();
                }*/

                PcUiBotPageDefine pageDefine = this.createPage(executeContext, getDataAction, new HashMap(), useHasNext);
                pageDefine.getExecuteContext().setOpenWindowType(tmOperation.getOperate());
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(multipleSelect);
                pageDefine.setSubmitType(submitType);
                pageDefines.add(pageDefine);
            });
        }
        // 设置没有配置dataAction的客制开窗
        else if (null != tmOperation.getOpenWindowDefine()
                && tmOperation.getOpenWindowDefine().getIsCustomize() != null && tmOperation.getOpenWindowDefine().getIsCustomize()) {//&& tmOperation.getOpenWindowDefine().getIsCustomize()
            PcUiBotPageDefine pageDefine = new PcUiBotPageDefine();
            PcUiBotExecuteContext newExecuteContext = this.getActionExecuteContext(executeContext);
            pageDefine.setExecuteContext(newExecuteContext);
            newExecuteContext.setOpenWindowType(tmOperation.getOperate());
            PcUiBotSubmitType submitType = new PcUiBotSubmitType();
            submitType.setIsBatch(multipleSelect);
            pageDefine.setCanEdit(false);
            pageDefine.setSubmitType(submitType);
            pageDefines.add(pageDefine);
        } else if (PcUiBotActivityConstants.CATEGORYS.contains(executeContext.getCategory())
                && "browse-page-mobile".equals(executeContext.getPageCode())
                && null != tmOperation.getOpenWindowDefine()
                && tmOperation.getOpenWindowDefine().getIsCustomize() != null) {
            PcUiBotPageDefine pageDefine = new PcUiBotPageDefine();
            PcUiBotExecuteContext newExecuteContext = this.getActionExecuteContext(executeContext);
            pageDefine.setExecuteContext(newExecuteContext);
            pageDefine.setCanEdit(false);
            newExecuteContext.setOpenWindowType(tmOperation.getOperate());
            PcUiBotSubmitType submitType = new PcUiBotSubmitType();
            submitType.setIsBatch(multipleSelect);
            pageDefine.setSubmitType(submitType);
            pageDefines.add(pageDefine);
        }
        return pageDefines;
    }


    private PcUiBotPageDefine createPage(PcUiBotExecuteContext executeContext, PcUiBotTmQueryAction tmAction, Map paras, Boolean useHasNext) {
        if (null == tmAction) {
            return null;
        }

        PcUiBotPageDefine pageDefine = new PcUiBotPageDefine();
        PcUiBotExecuteContext newExecuteContext = getActionExecuteContext(executeContext);
        pageDefine.setExecuteContext(newExecuteContext);
        /**
         * FIXME 需要待测试后确定是否在处理时，需要完全按照PC UI Bot的逻辑进行。因为涉及到的service类和实体类太多，几乎等于代码全部搬过来。
         */
        PcUiBotDataSourceDTO dataSourceBase = tmActionDataSourceService.analysis(executeContext, tmAction.getName(), tmAction, paras);
        /**
         * xuxx 2022-2-10 add若开启分页则拼接分页所需入参
         * 1、入参拼接：
         *          1.1、解析业务入参
         *          1.2、拼接search_value入参
         *          1.3、拼接分页入参：use_has_next、page_size、page_no
         */
        appendPageParas(useHasNext, pageDefine);
        PcUiBotDataSourceSetDTO dataSourceSet = PcUiBotDataSourceSetDTO.create(dataSourceBase);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setTitle(tmAction.getTitle());
        pageDefine.setCanEdit(false);
        pageDefine.getExecuteContext().setOpenWindow(true);
        pageDefine.setUseHasNext(useHasNext);

        /**
         * xuxx 2022-03-07 add 高级查询条件，
         * 为了兼容客制页面调用标准开窗，先透传到前端。
         * 在打开窗的时候，根据配置动态生成对应信息的组件
         */
        appendSearchInfos(dataSourceBase, tmAction);
        pageDefine.setRelationTag(executeContext.getRelationTag());
        return pageDefine;
    }

    private void appendPageParas(Boolean useHasNext, PcUiBotPageDefine pageDefine) {
        if (useHasNext != null && useHasNext) {
            PcUiBotPageInfo pageInfo = new PcUiBotPageInfo();
            pageDefine.setPageInfo(pageInfo);
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(50);
        }
    }

    private void appendSearchInfos(PcUiBotDataSourceDTO dataSourceBase, PcUiBotTmQueryAction tmAction) {
        if (tmAction.getSearchInfos() != null && dataSourceBase.getAction() != null) {
            dataSourceBase.getAction().setSearchInfos(tmAction.getSearchInfos());
        }
    }

    /**
     * 创建开窗按钮
     *
     * @param tmOperation
     * @param executeContext
     * @return
     */
    private List<PcUiBotOpenWindowDefineButtonDTO> createButtons(PcUiBotExecuteContext executeContext, PcUiBotTmOperation tmOperation, Boolean isFlowEngine) {
        List<PcUiBotOpenWindowDefineButtonDTO> newButtons = new ArrayList<>();
        List<PcUiBotTmOperationOpenWindowDefineButton> buttons = tmOperation.getOpenWindowDefine().getButtons();
        if (!CollectionUtils.isEmpty(buttons)) {
            buttons.forEach(tmOperationOpenWindowDefineButton -> {
                PcUiBotOpenWindowDefineButtonDTO openWindowDefineButtonDTO = new PcUiBotOpenWindowDefineButtonDTO();
                openWindowDefineButtonDTO.setId(tmOperationOpenWindowDefineButton.getId());
                openWindowDefineButtonDTO.setTitle(tmOperationOpenWindowDefineButton.getTitle());
                List<PcUiBotSubmitAction> submitActionList = new ArrayList<>();
                for (PcUiBotTmAction tmSubmitAction : tmOperationOpenWindowDefineButton.getActions()) {
                    PcUiBotSubmitAction submitAction = createSubmitAction(executeContext, tmSubmitAction, isFlowEngine);
                    if (!"UI".equals(submitAction.getCategory())) {
                        if (submitAction.getExecuteContext() == null) {
                            submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, executeContext.getTaskWithBacklogData()));
                        }
                    } else {
                        submitAction.setExecuteContext(null);
                    }
                    if (null != tmOperation.getOpenWindowDefine().getSubmitType()) {
                        submitAction.setSubmitType(tmOperation.getOpenWindowDefine().getSubmitType());
                    }
                    submitActionList.add(submitAction);
                }
                openWindowDefineButtonDTO.setActions(submitActionList);
                newButtons.add(openWindowDefineButtonDTO);
            });
        }
        return newButtons;
    }

    private List<PcUiBotSubmitAction> createSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmOperation tmOperation, List<PcUiBotTmAction> tmSubmitActions) {
        List<PcUiBotSubmitAction> submitActions = new ArrayList<>();
        if (CollectionUtils.isEmpty(tmSubmitActions)) {
            return submitActions;
        }

        for (PcUiBotTmAction tmSubmitAction : tmSubmitActions) {
            PcUiBotSubmitAction submitAction = submitActionCreateService.createSubmitAction(tmSubmitAction, executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext);
            submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));

            if (null != tmOperation.getOpenWindowDefine().getSubmitType()) {
                submitAction.setSubmitType(tmOperation.getOpenWindowDefine().getSubmitType());
            }
            if (null != submitAction) {
                submitActions.add(submitAction);
            }
        }
        return submitActions;
    }

    private PcUiBotExecuteContext getActionExecuteContext(PcUiBotExecuteContext executeContext) {
        return PcUiBotExecuteContext.builder()
                .projectData(executeContext.getProjectData())
                .taskWithBacklogDataList(executeContext.getTaskWithBacklogDataList())
//                    .taskWithBacklogData(executeContext.getTaskWithBacklogData())
                .pageCode(executeContext.getPageCode())
                .dataStateCode(executeContext.getDataStateCode())
                .pattern(executeContext.getPattern())
                .category(executeContext.getCategory())
                .relationTag(executeContext.getRelationTag())
                .identity(executeContext.getIdentity())
                .tmActivityId(executeContext.getTmActivityId())
                .tmProjectId(executeContext.getTmProjectId())
                .locale(executeContext.getLocale())
                .clientAgent(executeContext.getClientAgent())
                .deviceType(executeContext.getDeviceType())
                .deviceValue(executeContext.getDeviceValue())
                .authoredUser(executeContext.getAuthoredUser())
                .tenantId(executeContext.getAuthoredUser().getTenantId())
                .openWindow(executeContext.getOpenWindow())
                .openWindowType(executeContext.getOpenWindowType())
                .businessUnit(executeContext.getBusinessUnit())
                .activityParameter(executeContext.getActivityParameter())
                .build();
    }

    private PcUiBotSubmitAction createSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmAction tmSubmitAction, Boolean isFlowEngine) {

        if (executeContext.getProjectData() == null || executeContext.getTaskWithBacklogData() == null || CollectionUtils.isEmpty(executeContext.getTaskWithBacklogData().getBacklog())) {
            return submitActionCreateService.createSubmitAction(tmSubmitAction, executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext);
        }

        if (isFlowEngine) {
            return taskSubmitActionCreateService.create(executeContext, executeContext.getProjectData(), executeContext.getTaskWithBacklogData(), tmSubmitAction);
        } else {
            return newTaskSubmitActionCreateService.create(executeContext, executeContext.getProjectData(), executeContext.getTaskWithBacklogData(), tmSubmitAction, null);
        }
    }
}
