package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：附件TAG解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentTagAnalyzer
 * @Author: zaregoto
 * @Date: 2023/3/2 15:48
 */
@Slf4j
@Component("attachmentTagAnalyzer")
public class AttachmentTagAnalyzer implements DesignerTagAnalyzer {
    @Override
    public String getTagCode() {
        return "BUSINESS_ATTACHMENT_FILE";
    }

    @Override
    public boolean tagCodeDecideComponentType() {
        return true;
    }

    @Override
    public boolean tagCodeChangeComponentState() {
        return false;
    }

    @Override
    public void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag) {
        if (baseBizField instanceof UiBotTableColumn) {
            // 运行时，pc字段会有FILE_UPLOAD或TASK_FILE_UPLOAD两种类型。
            // 而移动端解析时判断类型中是否包含"UPLOAD"关键字，所以这里直接给UPLOAD即可。
            baseBizField.setType("UPLOAD");
        } else if (baseBizField instanceof UiBotLayout) {
            baseBizField.setType("FORM_UPLOAD");
        } else {
            // 不做任何事
        }
    }
}
