package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：设计器配置的Tag解析接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DesignerTagAnalyzer
 * @Author: Zaregoto
 * @Date: 2023/3/1 16:58
 */
public interface DesignerTagAnalyzer {

    /**
     * 返回TAG解析器所属TAG编码
     *
     * @return
     */
    String getTagCode();

    /**
     * 返回所属TAG编码是否可决定生成的组件类型
     *
     * @return
     */
    boolean tagCodeDecideComponentType();

    /**
     * 返回所属TAG编码是否可以改变组件的状态<br/>
     * 状态举例：组件的读写状态……等
     *
     * @return
     */
    boolean tagCodeChangeComponentState();

    /**
     * 执行TAG解析动作
     *
     * @param uiBotModelContext 渲染DSL上下文
     * @param baseBizField      待处理的字段
     * @param knowledgeMapsTag  待解析的TAG
     */
    void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag);
}
