package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: KnowledgeMapsTagAnalyzerFactory
 * @Author: Zaregoto
 * @Date: 2023/3/1 16:58
 */
@Component("knowledgeMapsTagAnalyzerFactory")
public class DesignerTagAnalyzerFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, DesignerTagAnalyzer> analyzerMap = new HashMap<>();

    private ApplicationContext appContext;

    private static final String TAG_CODE_SPLITTER = "__";

    public DesignerTagAnalyzer get(String tagCode) {
        /**
         * Tag对象的JSON示例
         *  {
         *      "code": "performer__HelloAthena_Demo_helloathena_task0001__ORDER_80",
         *      "name": "顺序80",
         *      "extendedInfo": {},
         *      "id": 680070273835204608,
         *      "category": "ORDER"
         *  },
         *  {
         *      "code": "performer__HelloAthena_Demo_helloathena_task0001__UNEDITABLE",
         *      "name": "不可编辑",
         *      "extendedInfo": {},
         *      "id": 683346235800682496,
         *      "category": "DISPLAY"
         *  },
         *  {
         *      "name": "手写签名",
         *      "extendedInfo": {},
         *      "id": 162991836,
         *      "code": "performer__HelloAthena_Demo_helloathena_task0001__BUSINESS_INPUT_SIGN",
         *      "category": "DISPLAY"
         *  },
         */
        String[] splitTagCode = tagCode.split(TAG_CODE_SPLITTER);
        if (splitTagCode.length != 3) {
            return null;
        }
        // 字符串解析出来得到的TAG编码
        String tagDesc = splitTagCode[2];
        String targetAnalyzerKey = "";
        for (String analyzerKey : analyzerMap.keySet()) {
            if (tagDesc.contains(analyzerKey)) {
                targetAnalyzerKey = analyzerKey;
                break;
            }
        }
        return analyzerMap.get(targetAnalyzerKey);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 DesignerTagAnalyzer 注册到 analyzerMap
        this.appContext.getBeansOfType(DesignerTagAnalyzer.class).values().forEach(
                strategy -> analyzerMap.put(strategy.getTagCode(), strategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public Map<String, DesignerTagAnalyzer> getAnalyzerMap() {
        return analyzerMap;
    }
}
