package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：移动端-手写签名TAG解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileInputSignTagAnalyzer
 * @Author: zaregoto
 * @Date: 2023/3/2 16:20
 */
@Slf4j
@Component("mobileInputSignTagAnalyzer")
public class MobileInputSignTagAnalyzer implements DesignerTagAnalyzer {
    @Override
    public String getTagCode() {
        return "BUSINESS_INPUT_SIGN";
    }

    @Override
    public boolean tagCodeDecideComponentType() {
        return true;
    }

    @Override
    public boolean tagCodeChangeComponentState() {
        return false;
    }

    @Override
    public void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag) {
        baseBizField.setType(ColumnTagDefinitionCodeEnum.INPUT_SIGN.getCode());
    }
}
