package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：百分比输入框TAG解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PercentInputTagAnalyzer
 * @Author: zaregoto
 * @Date: 2023/3/7 15:08
 */
@Slf4j
@Component("percentInputTagAnalyzer")
public class PercentInputTagAnalyzer implements DesignerTagAnalyzer {
    @Override
    public String getTagCode() {
        return "BUSINESS_PERCENT_INPUT";
    }

    @Override
    public boolean tagCodeDecideComponentType() {
        return true;
    }

    @Override
    public boolean tagCodeChangeComponentState() {
        return false;
    }

    @Override
    public void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag) {
        baseBizField.setType("PERCENT_INPUT");
    }
}
