package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：文本域TAG解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TextAreaTextTagAnalyzer
 * @Author: zaregoto
 * @Date: 2023/3/2 15:48
 */
@Slf4j
@Component("textAreaTextTagAnalyzer")
public class TextAreaTextTagAnalyzer implements DesignerTagAnalyzer {
    @Override
    public String getTagCode() {
        return "TEXTAREA_TEXT";
    }

    @Override
    public boolean tagCodeDecideComponentType() {
        return true;
    }

    @Override
    public boolean tagCodeChangeComponentState() {
        return false;
    }

    @Override
    public void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag) {
        if (baseBizField instanceof UiBotTableColumn) {
            baseBizField.setType("TEXTAREA_TEXT");
        } else if (baseBizField instanceof UiBotLayout) {
            baseBizField.setType("TEXTAREA");
        } else {
            // 不做任何事
        }
    }
}
