package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：不可编辑TAG解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UneditableTagAnalyzer
 * @Author: zaregoto
 * @Date: 2023/3/1 17:15
 */
@Slf4j
@Component("uneditableTagAnalyzer")
public class UneditableTagAnalyzer implements DesignerTagAnalyzer {
    @Override
    public String getTagCode() {
        return "UNEDITABLE";
    }

    @Override
    public boolean tagCodeDecideComponentType() {
        return false;
    }

    @Override
    public boolean tagCodeChangeComponentState() {
        return true;
    }

    @Override
    public void analyze(UiBotModel uiBotModelContext, UiBotBizFieldBase baseBizField, KnowledgeMapsTag knowledgeMapsTag) {
        baseBizField.doSetCanNotEdit();
    }
}
