package com.digiwin.mobile.mobileuibot.device.enums;

import lombok.Getter;

/**
 * <p>功能描述：设备绑定认证类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AuthTypeEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/7/31 15:41
 */
@Getter
public enum AuthTypeEnum {
    /**
     * 验证通过
     */
    PASS(0),
    /**
     * 联系管理员开通
     */
    OPENED(1),
    /**
     * 自动绑定
     */
    AUTO(2),
    /**
     * 不支持
     */
    UNSUPPORT(3),
    ;

    private final Integer value;

    AuthTypeEnum(Integer value) {
        this.value = value;
    }

}
