package com.digiwin.mobile.mobileuibot.device.service;

import com.digiwin.mobile.mobileuibot.device.model.ApiRequsetDeviceBind;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindAuth;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindConfig;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindResp;

import java.util.List;

/**
 * <p>功能描述：设备绑定服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DeviceBindService.java
 * @Author: wangjwc
 * @Date: created at 2025/7/31 15:49
 */
public interface DeviceBindService {
    /**
     * 获取设备绑定配置信息
     * @return 设备绑定配置信息
     */
    DeviceBindConfig deviceBindConfig();
    /**
     * 重新设备绑定列表
     * @param iamUserToken 用户token
     * @return 设备绑定列表
     */
    List<DeviceBindResp> deviceBindList(String iamUserToken);

    /**
     * 设备绑定认证
     * @param requsetDeviceBind 设备绑定请求参数
     * @return 设备绑定认证信息
     */
    DeviceBindAuth deviceBindAuth(ApiRequsetDeviceBind requsetDeviceBind);

    /**
     * 账号设备首次绑定
     * @param requsetDeviceBind 设备绑定请求参数
     * @return 设备绑定结果
     */
    Boolean deviceBindAuto(ApiRequsetDeviceBind requsetDeviceBind);
}
