package com.digiwin.mobile.mobileuibot.device.service.impl;

import com.digiwin.mobile.mobileuibot.device.model.ApiRequsetDeviceBind;
import com.digiwin.mobile.mobileuibot.device.service.DeviceBindService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindAuth;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindConfig;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindReq;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：设备绑定服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DeviceBindServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2025/7/31 15:50
 */
@Service
@Slf4j
public class DeviceBindServiceImpl implements DeviceBindService {

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Override
    public DeviceBindConfig deviceBindConfig() {
        return digiwinSemcProxyService.deviceBindConfig();
    }

    @Override
    public List<DeviceBindResp> deviceBindList(String iamUserToken) {
        return digiwinSemcProxyService.deviceBindList(iamUserToken);
    }

    @Override
    public DeviceBindAuth deviceBindAuth(ApiRequsetDeviceBind requsetDeviceBind) {
        // 构建请求参数
        DeviceBindReq deviceBindReq = new DeviceBindReq()
                .setDeviceId(requsetDeviceBind.getDeviceId())
                .setDeviceName(requsetDeviceBind.getDeviceName())
                .setTerminalType(1)
                .setDeviceModel(requsetDeviceBind.getDeviceModel())
                .setHardwareUuid("")
                .setMacAddress("")
                .setOsType(requsetDeviceBind.getOsType());
        return digiwinSemcProxyService.deviceBindAuth(deviceBindReq);
    }

    @Override
    public Boolean deviceBindAuto(ApiRequsetDeviceBind requsetDeviceBind) {
        // 构建请求参数
        DeviceBindReq deviceBindReq = new DeviceBindReq()
                .setDeviceId(requsetDeviceBind.getDeviceId())
                .setDeviceName(requsetDeviceBind.getDeviceName())
                .setTerminalType(1)
                .setDeviceModel(requsetDeviceBind.getDeviceModel())
                .setHardwareUuid("")
                .setMacAddress("")
                .setOsType(requsetDeviceBind.getOsType());
        return digiwinSemcProxyService.deviceBindAuto(deviceBindReq);
    }

}
