package com.digiwin.mobile.mobileuibot.environment;

import com.digiwin.mobile.mobileuibot.environment.config.EnvConfigModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * Athena全局应用配置
 *
 * @author wuyang
 */
@Document(collection = "environmentConfig")
@Data
@Accessors(chain = true)
public class EnvironmentConfig implements Serializable {
    private static final long serialVersionUID = -6604908032362877099L;

    @Field("_id")
    private String id;

    /**
     * 配置
     */
    private EnvConfigModel config;
}
