package com.digiwin.mobile.mobileuibot.environment;

import com.digiwin.mobile.mobileuibot.api.ApiRequestEnvConfig;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 环境配置相关接口
 *
 * @author zhangjj
 * @date 2021/12/9 0009 14:04
 */
@RestController
@RequestMapping("/mobile/envir")
public class EnvironmentController {

    @Autowired
    private EnvironmentService environmentService;

    @RequestMapping(value = "/config", method = RequestMethod.POST)
    public ApiResponse<Map<String, Object>> getEnvironmentConfig(@RequestBody ApiRequestEnvConfig apiRequestEnvConfig) {
        Map<String, Object> environmentConfig = environmentService.getEnvironmentConfig(apiRequestEnvConfig);
        return ApiResponse.buildOK().setData(environmentConfig);
    }
}
