package com.digiwin.mobile.mobileuibot.environment;

import com.digiwin.mobile.mobileuibot.api.ApiRequestEnvConfig;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.pageskeleton.PageSkeleton;
import com.digiwin.mobile.mobileuibot.core.pageskeleton.PageSkeletonService;
import com.digiwin.mobile.mobileuibot.environment.config.EnvConfigModel;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppCommonConfig;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppConfig;
import com.digiwin.mobile.mobileuibot.environment.config.EvnAppCustomizeConfig;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：环境配置 service 层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnvironmentService.java
 * @Author: wangjwc
 * @Date: created at 2023/6/7 16:43
 */
@Slf4j
@Service
public class EnvironmentService {

    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private PageSkeletonService pageSkeletonService;
    @Autowired
    private EnvironmentConfigService environmentConfigService;

    public Map<String, Object> getEnvironmentConfig(ApiRequestEnvConfig apiRequestEnvConfig) {
        boolean getPageSkeletonConfig = apiRequestEnvConfig.getGetPageSkeletonConfig();
        Map<String, Object> map = new HashMap<>();

        map.put("skeleton", getSkeletonMap());
        //只获取骨架屏的配置
        if (getPageSkeletonConfig) {
            return map;
        }
        Map<String, Object> appConfig = getAppConfig();
        // 服务器配置
        map.putAll(appConfig);
        // 获取mqtt配置
        map.put("mqtt", this.getMqttMap(Boolean.TRUE.equals(appConfig.get("enableMqtt"))));
        // 端上埋点开关
        map.put("switchTracking", sysEnvConfig.getSwitchTracking());
        return map;
    }

    private Map<String, Object> getMqttMap(Boolean enableMqtt) {
        Map<String, Object> mqttConfig = new HashMap<>(8);
        if (enableMqtt) {
            enableMqtt = "true".equalsIgnoreCase(AppContext.getApiUrlSetting().getEnableMqtt());
        }
        mqttConfig.put("enableMqtt", enableMqtt);
        mqttConfig.put("mqttUrl", AppContext.getApiUrlSetting().getMqttUrl());
        mqttConfig.put("mqttPort", AppContext.getApiUrlSetting().getMqttPort());
        mqttConfig.put("mqttPath", AppContext.getApiUrlSetting().getMqttPath());
        mqttConfig.put("mqttUserName", AppContext.getApiUrlSetting().getMqttUserName());
        mqttConfig.put("mqttPassword", AppContext.getApiUrlSetting().getMqttPassword());
        mqttConfig.put("mqttTopicServerName", AppContext.getApiUrlSetting().getServerName());
        mqttConfig.put("mqttTopicServerNameASA", sysEnvConfig.getMqttTopicServerNameASA());
        return mqttConfig;
    }

    public Map<String, Object> getAppConfig() {
        Map<String, Object> appEnvironmentConfig = new HashMap<>(8);
        List<EnvironmentConfig> environmentConfigs = this.environmentConfigService.getEnvironmentConfig();
        log.debug("mongodb environmentConfig data:{}", JsonUtil.javaObjectToJsonString(environmentConfigs));
        if (CollectionUtils.isEmpty(environmentConfigs)) {
            return appEnvironmentConfig;
        }
        EnvironmentConfig environmentConfig = environmentConfigs.get(0);
        EnvConfigModel envConfigModel = environmentConfig.getConfig();
        if (null == envConfigModel) {
            return appEnvironmentConfig;
        }
        EvnAppConfig appConfig = envConfigModel.getAppConfig();
        if (null == appConfig) {
            return appEnvironmentConfig;
        }
        List<EvnAppCustomizeConfig> customizeConfig = appConfig.getCustomizeConfig();
        if (!CollectionUtils.isEmpty(customizeConfig)) {
            for (EvnAppCustomizeConfig config : customizeConfig) {
                appEnvironmentConfig.put(config.getName(), config);
            }
        }
        EvnAppCommonConfig commonConfig = appConfig.getCommonConfig();
        if (null != commonConfig) {
            appEnvironmentConfig.putAll(JsonUtil.objectToJavaObject(commonConfig, new TypeReference<Map<String, Object>>() {
            }));
        }
        return appEnvironmentConfig;
    }

    private Map<String, Object> getSkeletonMap() {
        List<PageSkeleton> pageSkeletons = this.pageSkeletonService.getAllSkeletonConfig();
        Map<String, Object> skeletonMap = new HashMap<>(pageSkeletons.size());
        for (PageSkeleton pageSkeleton : pageSkeletons) {
            skeletonMap.put(pageSkeleton.getPageId(), pageSkeleton.getSkeletons());
        }
        return skeletonMap;
    }

}
