package com.digiwin.mobile.mobileuibot.environment.config;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 功能: 服务端应用配置
 *
 * @author: wjw
 * @date: created at 2023/2/1
 */
@Data
@Accessors(chain = true)
public class EnvServerConfig implements Serializable {
    /**
     * 智驱中台 组件 请求头添加租户ID 效验 开关
     */
    private Boolean athenaApiSwitch;

    /**
     * mock录制 配置
     */
    private MockConfig mock;

    public List<String> getMockSuperAdmins() {
        if (this.mock == null) {
            return Collections.emptyList();
        }
        List<String> superAdmins = this.mock.getSuperAdmins();
        return CollectionUtils.isEmpty(superAdmins) ? Collections.emptyList() : superAdmins;
    }

    @Data
    @Accessors(chain = true)
    private class MockConfig {
        /**
         * 超级管理员 配置，可以看到所有录制数据
         */
        private List<String> superAdmins;
    }
}
