package com.digiwin.mobile.mobileuibot.espapi;

import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.DigiwinEspCallbackManager;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspExecution;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：ESP api接口与回调接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EspApiController.java
 * @Author: wangjwc
 * @Date: created at 2024/9/26 18:00
 */
@RestController
@RequestMapping(value = "/eai")
public class EspApiController {

    @PostMapping(value = "")
    public DigiwinEspResponse openApi(HttpServletRequest request, HttpServletResponse response) {
        DigiwinEspResponse digiwinEspResponse = new DigiwinEspResponse();
        String digiServiceStr = request.getHeader("digi-service");
        EspDigiService espDigiService = JsonUtil.jsonStringToObject(digiServiceStr, EspDigiService.class);
        String apiName = espDigiService.getName();
        response.setHeader("content-type", "application/json; charset=utf-8");
        response.setHeader("digi-srvver", "1.0");
        response.setHeader("digi-srvcode", "000");
        if ("mobile.api.test".equalsIgnoreCase(apiName)) {
            digiwinEspResponse.setStdData(mobileApiTest());
            return digiwinEspResponse;
        }
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        Map<String, Object> parameter = new HashMap<>();
        String data = null;
        if ("mobile.test.project.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText("static/esp_demo/esp_mobile_test_project_get.json");
        } else if ("mobile.test.task.list.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText("static/esp_demo/esp_mobile_test_task_list_get.json");
        } else if ("mobile.test.project.task.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText("static/esp_demo/esp_mobile_test_project_task_get.json");
        } else if ("mobile.smart.transport.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText("static/esp_demo/esp_mobile_smart_transport_get.json");
        } else if ("mobile.smart.transport.update".equalsIgnoreCase(apiName)) {
            data = "{}";
        }
        if (StringUtils.hasLength(data)) {
            parameter = JsonUtil.jsonStringToObject(data, Map.class);
        } else {
            parameter.put("msg", apiName + " not found");
        }
        digiwinEspStdData.setParameter(parameter);
        DigiwinEspExecution digiwinEspExecution = new DigiwinEspExecution();
        digiwinEspExecution.setCode("0");
        digiwinEspExecution.setDescription("success");
        digiwinEspStdData.setExecution(digiwinEspExecution);
        digiwinEspResponse.setStdData(digiwinEspStdData);
        return digiwinEspResponse;
    }

    private DigiwinEspStdData mobileApiTest() {
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        Map<String, Object> parameter = new HashMap<>();
        digiwinEspStdData.setParameter(parameter);
        parameter.put("api", "Mobile-api-test");
        return digiwinEspStdData;
    }

    @PostMapping(value = "/callback")
    public DigiwinEspResponse callback(HttpServletRequest request, @RequestBody DigiwinEspResponse digiwinEspResponse, HttpServletResponse response) {
        Map<String, Object> parameter = new HashMap<>();
        if (ObjectUtils.isNotEmpty(digiwinEspResponse.getStdData()) && ObjectUtils.isNotEmpty(digiwinEspResponse.getStdData().getParameter())) {
            parameter = digiwinEspResponse.getStdData().getParameter();
        }
        String digiReqId = Optional.ofNullable(request.getHeader("digi-reqid")).orElse("");
        // 无论是否存在参数，都通知回调
        DigiwinEspCallbackManager.notifyDataReceived(digiReqId, JsonUtil.javaObjectToJsonString(parameter));
        return this.buildEspOk(response);
    }

    private DigiwinEspResponse buildEspOk(HttpServletResponse response) {
        response.setHeader("content-type", "application/json; charset=utf-8");
        response.setHeader("digi-srvver", "1.0");
        response.setHeader("digi-srvcode", "000");
        DigiwinEspResponse digiwinEspResponse = new DigiwinEspResponse();
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        digiwinEspStdData.setParameter(new HashMap<>());
        DigiwinEspExecution digiwinEspExecution = new DigiwinEspExecution();
        digiwinEspExecution.setCode("0");
        digiwinEspExecution.setDescription("success");
        digiwinEspStdData.setExecution(digiwinEspExecution);
        digiwinEspResponse.setStdData(digiwinEspStdData);
        return digiwinEspResponse;
    }

}
