package com.digiwin.mobile.mobileuibot.experience.dao.impl;

import com.digiwin.mobile.mobileuibot.experience.dao.ExperienceRoleRepository;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRole;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangjj
 * @date 2022/9/14 11:00
 */
@Component
public class ExperienceRoleRepositoryImpl implements ExperienceRoleRepository {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<ExperienceRole> getRoleList() {
        return mongoTemplate.findAll(ExperienceRole.class)
                .stream().map(ExperienceRole::convert)
                .filter(role -> BooleanUtils.isTrue(role.getValid()))
                .collect(Collectors.toList());
    }
}