package com.digiwin.mobile.mobileuibot.experience.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 体验角色model
 *
 * @author zhangjj
 * @date 2022/9/14 10:25
 */

@Document(collection = "experienceRole")
@Data
public class ExperienceRole implements Serializable {

    private static final long serialVersionUID = -2199790037720309364L;

    @Id
    private String id;
    /**
     * 角色id
     */
    private String roleId;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 角色名称多语言map
     */
    private Map<String, String> roleNameMap;
    /**
     * 用户名
     */
    private String userId;
    /**
     * 用户密码
     */
    private String password;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 是否为娜娜应用 0：否 1：是
     */
    private Integer nanaAssistant;

    /**
     * 是否有效 true：有效；false：无效
     * 默认：false
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Boolean valid;
    private Action action;

    //**********************环境下配置******************************
    /**
     * 环境类型
     *
     * @see com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private String type;
    /**
     * 大陆区 环境配置
     * 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private List<ExperienceRole> cn;
    /**
     * 台湾区 环境配置
     * 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private List<ExperienceRole> tw;

    public ExperienceRole() {

    }

    public ExperienceRole(String id, String roleId, String roleName, Integer sort) {
        this.id = id;
        this.roleId = roleId;
        this.roleName = roleName;
        this.sort = sort;
    }

    /**
     * 根据语言别设置角色名称
     */
    /*public void setRoleName(String locale) {
        if (roleNameMap == null) {
            return;
        }
        locale = locale != null ? locale : "zh_CN";
        roleName = roleNameMap.get(locale);
    }*/

    public ExperienceRole convert() {
        // 环境部署的地区
        String envDeployArea = AppContext.getEnvDeployArea();
        if (AppEnvDeployAreaEnum.CN.name().equals(envDeployArea)) {
            // 大陆
            this.convertByArea(this.cn);
        } else if (AppEnvDeployAreaEnum.TW.name().equals(envDeployArea)) {
            // 台湾
            this.convertByArea(this.tw);
        }
        return this;
    }

    private void convertByArea(List<ExperienceRole> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return;
        }
        // prod--表示生产环境；test--表示测试环境；dev-表示开发环境
        String envType = AppContext.getEnvType();
        Optional<ExperienceRole> optional =
                roles.stream().filter(r ->
                        StringUtils.hasLength(r.getType())
                                && r.getType().equals(envType)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        ExperienceRole role = optional.get();
        if (null != role.getRoleId()) {
            this.roleId = role.getRoleId();
        }
        if (null != role.getRoleName()) {
            this.roleName = role.getRoleName();
        }
        if (null != role.getRoleNameMap()) {
            this.roleNameMap = role.getRoleNameMap();
        }
        if (null != role.getUserId()) {
            this.userId = role.getUserId();
        }
        if (null != role.getPassword()) {
            this.password = role.getPassword();
        }
        if (null != role.getSort()) {
            this.sort = role.getSort();
        }
        if (null != role.getNanaAssistant()) {
            this.nanaAssistant = role.getNanaAssistant();
        }

        if (null != role.getValid()) {
            this.valid = role.getValid();
        }
        if (null != role.getAction()) {
            if (null == this.action) {
                this.action = new Action();
            }
            this.action.convert(role.getAction());
        }
    }
}