package com.digiwin.mobile.mobileuibot.experience.model;

import java.util.Objects;

/**
 * <p>功能描述：系统内置的体验角色ID枚举类</p>
 *
 * @FileName: ExperienceRoleIdEnum
 * @Author: zaregoto
 * @Date: 2024/4/9 22:00
 */
public enum ExperienceRoleIdEnum {
    /**
     * 娜娜-数据助理-高管数智助理方案
     */
    NANA_DATA_ASSISTANT_CXO("CXO"),
    /**
     * 娜娜-差旅助理
     */
    NANA_DATA_ASSISTANT_TRAVEL("TRAVEL"),
    /**
     * 娜娜-行政助理
     */
    NANA_DATA_ASSISTANT_ASAAA("ASAAA"),
    /**
     * athena-mock场景
     */
    ATHENA_MOCK("MOCK"),
    ;

    private final String value;

    ExperienceRoleIdEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static ExperienceRoleIdEnum getEnumByValue(String value) {
        for (ExperienceRoleIdEnum testedEnum : ExperienceRoleIdEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
